/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.connectparticipant.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.connectparticipant.model.Receipt;
import com.amazonaws.services.connectparticipant.model.transform.MessageMetadataMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class MessageMetadata
implements Serializable,
Cloneable,
StructuredPojo {
    private String messageId;
    private List<Receipt> receipts;

    public void setMessageId(String messageId) {
        this.messageId = messageId;
    }

    public String getMessageId() {
        return this.messageId;
    }

    public MessageMetadata withMessageId(String messageId) {
        this.setMessageId(messageId);
        return this;
    }

    public List<Receipt> getReceipts() {
        return this.receipts;
    }

    public void setReceipts(Collection<Receipt> receipts) {
        if (receipts == null) {
            this.receipts = null;
            return;
        }
        this.receipts = new ArrayList<Receipt>(receipts);
    }

    public MessageMetadata withReceipts(Receipt ... receipts) {
        if (this.receipts == null) {
            this.setReceipts(new ArrayList<Receipt>(receipts.length));
        }
        for (Receipt ele : receipts) {
            this.receipts.add(ele);
        }
        return this;
    }

    public MessageMetadata withReceipts(Collection<Receipt> receipts) {
        this.setReceipts(receipts);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getMessageId() != null) {
            sb.append("MessageId: ").append(this.getMessageId()).append(",");
        }
        if (this.getReceipts() != null) {
            sb.append("Receipts: ").append(this.getReceipts());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MessageMetadata)) {
            return false;
        }
        MessageMetadata other = (MessageMetadata)obj;
        if (other.getMessageId() == null ^ this.getMessageId() == null) {
            return false;
        }
        if (other.getMessageId() != null && !other.getMessageId().equals(this.getMessageId())) {
            return false;
        }
        if (other.getReceipts() == null ^ this.getReceipts() == null) {
            return false;
        }
        return other.getReceipts() == null || other.getReceipts().equals(this.getReceipts());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getMessageId() == null ? 0 : this.getMessageId().hashCode());
        hashCode = 31 * hashCode + (this.getReceipts() == null ? 0 : this.getReceipts().hashCode());
        return hashCode;
    }

    public MessageMetadata clone() {
        try {
            return (MessageMetadata)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        MessageMetadataMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

