/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.connectparticipant.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.connectparticipant.model.Websocket;

@SdkInternalApi
public class WebsocketMarshaller {
    private static final MarshallingInfo<String> URL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Url").build();
    private static final MarshallingInfo<String> CONNECTIONEXPIRY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ConnectionExpiry").build();
    private static final WebsocketMarshaller instance = new WebsocketMarshaller();

    public static WebsocketMarshaller getInstance() {
        return instance;
    }

    public void marshall(Websocket websocket, ProtocolMarshaller protocolMarshaller) {
        if (websocket == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)websocket.getUrl(), URL_BINDING);
            protocolMarshaller.marshall((Object)websocket.getConnectionExpiry(), CONNECTIONEXPIRY_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

