/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.connectcases.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.connectcases.model.FieldItem;
import com.amazonaws.services.connectcases.model.transform.FieldGroupMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class FieldGroup
implements Serializable,
Cloneable,
StructuredPojo {
    private List<FieldItem> fields;
    private String name;

    public List<FieldItem> getFields() {
        return this.fields;
    }

    public void setFields(Collection<FieldItem> fields) {
        if (fields == null) {
            this.fields = null;
            return;
        }
        this.fields = new ArrayList<FieldItem>(fields);
    }

    public FieldGroup withFields(FieldItem ... fields) {
        if (this.fields == null) {
            this.setFields(new ArrayList<FieldItem>(fields.length));
        }
        for (FieldItem ele : fields) {
            this.fields.add(ele);
        }
        return this;
    }

    public FieldGroup withFields(Collection<FieldItem> fields) {
        this.setFields(fields);
        return this;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public FieldGroup withName(String name) {
        this.setName(name);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getFields() != null) {
            sb.append("Fields: ").append(this.getFields()).append(",");
        }
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FieldGroup)) {
            return false;
        }
        FieldGroup other = (FieldGroup)obj;
        if (other.getFields() == null ^ this.getFields() == null) {
            return false;
        }
        if (other.getFields() != null && !other.getFields().equals(this.getFields())) {
            return false;
        }
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        return other.getName() == null || other.getName().equals(this.getName());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getFields() == null ? 0 : this.getFields().hashCode());
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        return hashCode;
    }

    public FieldGroup clone() {
        try {
            return (FieldGroup)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        FieldGroupMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

