/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.connectcases.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.connectcases.model.AuditEventField;
import com.amazonaws.services.connectcases.model.AuditEventPerformedBy;
import com.amazonaws.services.connectcases.model.AuditEventType;
import com.amazonaws.services.connectcases.model.RelatedItemType;
import com.amazonaws.services.connectcases.model.transform.AuditEventMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class AuditEvent
implements Serializable,
Cloneable,
StructuredPojo {
    private String eventId;
    private List<AuditEventField> fields;
    private AuditEventPerformedBy performedBy;
    private Date performedTime;
    private String relatedItemType;
    private String type;

    public void setEventId(String eventId) {
        this.eventId = eventId;
    }

    public String getEventId() {
        return this.eventId;
    }

    public AuditEvent withEventId(String eventId) {
        this.setEventId(eventId);
        return this;
    }

    public List<AuditEventField> getFields() {
        return this.fields;
    }

    public void setFields(Collection<AuditEventField> fields) {
        if (fields == null) {
            this.fields = null;
            return;
        }
        this.fields = new ArrayList<AuditEventField>(fields);
    }

    public AuditEvent withFields(AuditEventField ... fields) {
        if (this.fields == null) {
            this.setFields(new ArrayList<AuditEventField>(fields.length));
        }
        for (AuditEventField ele : fields) {
            this.fields.add(ele);
        }
        return this;
    }

    public AuditEvent withFields(Collection<AuditEventField> fields) {
        this.setFields(fields);
        return this;
    }

    public void setPerformedBy(AuditEventPerformedBy performedBy) {
        this.performedBy = performedBy;
    }

    public AuditEventPerformedBy getPerformedBy() {
        return this.performedBy;
    }

    public AuditEvent withPerformedBy(AuditEventPerformedBy performedBy) {
        this.setPerformedBy(performedBy);
        return this;
    }

    public void setPerformedTime(Date performedTime) {
        this.performedTime = performedTime;
    }

    public Date getPerformedTime() {
        return this.performedTime;
    }

    public AuditEvent withPerformedTime(Date performedTime) {
        this.setPerformedTime(performedTime);
        return this;
    }

    public void setRelatedItemType(String relatedItemType) {
        this.relatedItemType = relatedItemType;
    }

    public String getRelatedItemType() {
        return this.relatedItemType;
    }

    public AuditEvent withRelatedItemType(String relatedItemType) {
        this.setRelatedItemType(relatedItemType);
        return this;
    }

    public AuditEvent withRelatedItemType(RelatedItemType relatedItemType) {
        this.relatedItemType = relatedItemType.toString();
        return this;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    public AuditEvent withType(String type) {
        this.setType(type);
        return this;
    }

    public AuditEvent withType(AuditEventType type) {
        this.type = type.toString();
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getEventId() != null) {
            sb.append("EventId: ").append(this.getEventId()).append(",");
        }
        if (this.getFields() != null) {
            sb.append("Fields: ").append(this.getFields()).append(",");
        }
        if (this.getPerformedBy() != null) {
            sb.append("PerformedBy: ").append(this.getPerformedBy()).append(",");
        }
        if (this.getPerformedTime() != null) {
            sb.append("PerformedTime: ").append(this.getPerformedTime()).append(",");
        }
        if (this.getRelatedItemType() != null) {
            sb.append("RelatedItemType: ").append(this.getRelatedItemType()).append(",");
        }
        if (this.getType() != null) {
            sb.append("Type: ").append(this.getType());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AuditEvent)) {
            return false;
        }
        AuditEvent other = (AuditEvent)obj;
        if (other.getEventId() == null ^ this.getEventId() == null) {
            return false;
        }
        if (other.getEventId() != null && !other.getEventId().equals(this.getEventId())) {
            return false;
        }
        if (other.getFields() == null ^ this.getFields() == null) {
            return false;
        }
        if (other.getFields() != null && !other.getFields().equals(this.getFields())) {
            return false;
        }
        if (other.getPerformedBy() == null ^ this.getPerformedBy() == null) {
            return false;
        }
        if (other.getPerformedBy() != null && !other.getPerformedBy().equals(this.getPerformedBy())) {
            return false;
        }
        if (other.getPerformedTime() == null ^ this.getPerformedTime() == null) {
            return false;
        }
        if (other.getPerformedTime() != null && !other.getPerformedTime().equals(this.getPerformedTime())) {
            return false;
        }
        if (other.getRelatedItemType() == null ^ this.getRelatedItemType() == null) {
            return false;
        }
        if (other.getRelatedItemType() != null && !other.getRelatedItemType().equals(this.getRelatedItemType())) {
            return false;
        }
        if (other.getType() == null ^ this.getType() == null) {
            return false;
        }
        return other.getType() == null || other.getType().equals(this.getType());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getEventId() == null ? 0 : this.getEventId().hashCode());
        hashCode = 31 * hashCode + (this.getFields() == null ? 0 : this.getFields().hashCode());
        hashCode = 31 * hashCode + (this.getPerformedBy() == null ? 0 : this.getPerformedBy().hashCode());
        hashCode = 31 * hashCode + (this.getPerformedTime() == null ? 0 : this.getPerformedTime().hashCode());
        hashCode = 31 * hashCode + (this.getRelatedItemType() == null ? 0 : this.getRelatedItemType().hashCode());
        hashCode = 31 * hashCode + (this.getType() == null ? 0 : this.getType().hashCode());
        return hashCode;
    }

    public AuditEvent clone() {
        try {
            return (AuditEvent)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        AuditEventMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

