/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.connectcases.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.connectcases.model.FieldIdentifier;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class GetCaseRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String caseId;
    private String domainId;
    private List<FieldIdentifier> fields;
    private String nextToken;

    public void setCaseId(String caseId) {
        this.caseId = caseId;
    }

    public String getCaseId() {
        return this.caseId;
    }

    public GetCaseRequest withCaseId(String caseId) {
        this.setCaseId(caseId);
        return this;
    }

    public void setDomainId(String domainId) {
        this.domainId = domainId;
    }

    public String getDomainId() {
        return this.domainId;
    }

    public GetCaseRequest withDomainId(String domainId) {
        this.setDomainId(domainId);
        return this;
    }

    public List<FieldIdentifier> getFields() {
        return this.fields;
    }

    public void setFields(Collection<FieldIdentifier> fields) {
        if (fields == null) {
            this.fields = null;
            return;
        }
        this.fields = new ArrayList<FieldIdentifier>(fields);
    }

    public GetCaseRequest withFields(FieldIdentifier ... fields) {
        if (this.fields == null) {
            this.setFields(new ArrayList<FieldIdentifier>(fields.length));
        }
        for (FieldIdentifier ele : fields) {
            this.fields.add(ele);
        }
        return this;
    }

    public GetCaseRequest withFields(Collection<FieldIdentifier> fields) {
        this.setFields(fields);
        return this;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public GetCaseRequest withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getCaseId() != null) {
            sb.append("CaseId: ").append(this.getCaseId()).append(",");
        }
        if (this.getDomainId() != null) {
            sb.append("DomainId: ").append(this.getDomainId()).append(",");
        }
        if (this.getFields() != null) {
            sb.append("Fields: ").append(this.getFields()).append(",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetCaseRequest)) {
            return false;
        }
        GetCaseRequest other = (GetCaseRequest)obj;
        if (other.getCaseId() == null ^ this.getCaseId() == null) {
            return false;
        }
        if (other.getCaseId() != null && !other.getCaseId().equals(this.getCaseId())) {
            return false;
        }
        if (other.getDomainId() == null ^ this.getDomainId() == null) {
            return false;
        }
        if (other.getDomainId() != null && !other.getDomainId().equals(this.getDomainId())) {
            return false;
        }
        if (other.getFields() == null ^ this.getFields() == null) {
            return false;
        }
        if (other.getFields() != null && !other.getFields().equals(this.getFields())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        return other.getNextToken() == null || other.getNextToken().equals(this.getNextToken());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getCaseId() == null ? 0 : this.getCaseId().hashCode());
        hashCode = 31 * hashCode + (this.getDomainId() == null ? 0 : this.getDomainId().hashCode());
        hashCode = 31 * hashCode + (this.getFields() == null ? 0 : this.getFields().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        return hashCode;
    }

    public GetCaseRequest clone() {
        return (GetCaseRequest)super.clone();
    }
}

