/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.connectcampaign.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.connectcampaign.model.transform.DialRequestMarshaller;
import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class DialRequest
implements Serializable,
Cloneable,
StructuredPojo {
    private String clientToken;
    private String phoneNumber;
    private Date expirationTime;
    private Map<String, String> attributes;

    public void setClientToken(String clientToken) {
        this.clientToken = clientToken;
    }

    public String getClientToken() {
        return this.clientToken;
    }

    public DialRequest withClientToken(String clientToken) {
        this.setClientToken(clientToken);
        return this;
    }

    public void setPhoneNumber(String phoneNumber) {
        this.phoneNumber = phoneNumber;
    }

    public String getPhoneNumber() {
        return this.phoneNumber;
    }

    public DialRequest withPhoneNumber(String phoneNumber) {
        this.setPhoneNumber(phoneNumber);
        return this;
    }

    public void setExpirationTime(Date expirationTime) {
        this.expirationTime = expirationTime;
    }

    public Date getExpirationTime() {
        return this.expirationTime;
    }

    public DialRequest withExpirationTime(Date expirationTime) {
        this.setExpirationTime(expirationTime);
        return this;
    }

    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(Map<String, String> attributes) {
        this.attributes = attributes;
    }

    public DialRequest withAttributes(Map<String, String> attributes) {
        this.setAttributes(attributes);
        return this;
    }

    public DialRequest addAttributesEntry(String key, String value) {
        if (null == this.attributes) {
            this.attributes = new HashMap<String, String>();
        }
        if (this.attributes.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.attributes.put(key, value);
        return this;
    }

    public DialRequest clearAttributesEntries() {
        this.attributes = null;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getClientToken() != null) {
            sb.append("ClientToken: ").append(this.getClientToken()).append(",");
        }
        if (this.getPhoneNumber() != null) {
            sb.append("PhoneNumber: ").append("***Sensitive Data Redacted***").append(",");
        }
        if (this.getExpirationTime() != null) {
            sb.append("ExpirationTime: ").append(this.getExpirationTime()).append(",");
        }
        if (this.getAttributes() != null) {
            sb.append("Attributes: ").append("***Sensitive Data Redacted***");
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DialRequest)) {
            return false;
        }
        DialRequest other = (DialRequest)obj;
        if (other.getClientToken() == null ^ this.getClientToken() == null) {
            return false;
        }
        if (other.getClientToken() != null && !other.getClientToken().equals(this.getClientToken())) {
            return false;
        }
        if (other.getPhoneNumber() == null ^ this.getPhoneNumber() == null) {
            return false;
        }
        if (other.getPhoneNumber() != null && !other.getPhoneNumber().equals(this.getPhoneNumber())) {
            return false;
        }
        if (other.getExpirationTime() == null ^ this.getExpirationTime() == null) {
            return false;
        }
        if (other.getExpirationTime() != null && !other.getExpirationTime().equals(this.getExpirationTime())) {
            return false;
        }
        if (other.getAttributes() == null ^ this.getAttributes() == null) {
            return false;
        }
        return other.getAttributes() == null || other.getAttributes().equals(this.getAttributes());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getClientToken() == null ? 0 : this.getClientToken().hashCode());
        hashCode = 31 * hashCode + (this.getPhoneNumber() == null ? 0 : this.getPhoneNumber().hashCode());
        hashCode = 31 * hashCode + (this.getExpirationTime() == null ? 0 : this.getExpirationTime().hashCode());
        hashCode = 31 * hashCode + (this.getAttributes() == null ? 0 : this.getAttributes().hashCode());
        return hashCode;
    }

    public DialRequest clone() {
        try {
            return (DialRequest)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        DialRequestMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

