/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.connect.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.connect.model.transform.ApplicationMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class Application
implements Serializable,
Cloneable,
StructuredPojo {
    private String namespace;
    private List<String> applicationPermissions;

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public Application withNamespace(String namespace) {
        this.setNamespace(namespace);
        return this;
    }

    public List<String> getApplicationPermissions() {
        return this.applicationPermissions;
    }

    public void setApplicationPermissions(Collection<String> applicationPermissions) {
        if (applicationPermissions == null) {
            this.applicationPermissions = null;
            return;
        }
        this.applicationPermissions = new ArrayList<String>(applicationPermissions);
    }

    public Application withApplicationPermissions(String ... applicationPermissions) {
        if (this.applicationPermissions == null) {
            this.setApplicationPermissions(new ArrayList<String>(applicationPermissions.length));
        }
        for (String ele : applicationPermissions) {
            this.applicationPermissions.add(ele);
        }
        return this;
    }

    public Application withApplicationPermissions(Collection<String> applicationPermissions) {
        this.setApplicationPermissions(applicationPermissions);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getNamespace() != null) {
            sb.append("Namespace: ").append(this.getNamespace()).append(",");
        }
        if (this.getApplicationPermissions() != null) {
            sb.append("ApplicationPermissions: ").append(this.getApplicationPermissions());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Application)) {
            return false;
        }
        Application other = (Application)obj;
        if (other.getNamespace() == null ^ this.getNamespace() == null) {
            return false;
        }
        if (other.getNamespace() != null && !other.getNamespace().equals(this.getNamespace())) {
            return false;
        }
        if (other.getApplicationPermissions() == null ^ this.getApplicationPermissions() == null) {
            return false;
        }
        return other.getApplicationPermissions() == null || other.getApplicationPermissions().equals(this.getApplicationPermissions());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getNamespace() == null ? 0 : this.getNamespace().hashCode());
        hashCode = 31 * hashCode + (this.getApplicationPermissions() == null ? 0 : this.getApplicationPermissions().hashCode());
        return hashCode;
    }

    public Application clone() {
        try {
            return (Application)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ApplicationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

