/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.connect.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.connect.model.EvaluationAnswerOutput;
import com.amazonaws.services.connect.model.EvaluationMetadata;
import com.amazonaws.services.connect.model.EvaluationNote;
import com.amazonaws.services.connect.model.EvaluationScore;
import com.amazonaws.services.connect.model.EvaluationStatus;
import com.amazonaws.services.connect.model.transform.EvaluationMarshaller;
import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class Evaluation
implements Serializable,
Cloneable,
StructuredPojo {
    private String evaluationId;
    private String evaluationArn;
    private EvaluationMetadata metadata;
    private Map<String, EvaluationAnswerOutput> answers;
    private Map<String, EvaluationNote> notes;
    private String status;
    private Map<String, EvaluationScore> scores;
    private Date createdTime;
    private Date lastModifiedTime;
    private Map<String, String> tags;

    public void setEvaluationId(String evaluationId) {
        this.evaluationId = evaluationId;
    }

    public String getEvaluationId() {
        return this.evaluationId;
    }

    public Evaluation withEvaluationId(String evaluationId) {
        this.setEvaluationId(evaluationId);
        return this;
    }

    public void setEvaluationArn(String evaluationArn) {
        this.evaluationArn = evaluationArn;
    }

    public String getEvaluationArn() {
        return this.evaluationArn;
    }

    public Evaluation withEvaluationArn(String evaluationArn) {
        this.setEvaluationArn(evaluationArn);
        return this;
    }

    public void setMetadata(EvaluationMetadata metadata) {
        this.metadata = metadata;
    }

    public EvaluationMetadata getMetadata() {
        return this.metadata;
    }

    public Evaluation withMetadata(EvaluationMetadata metadata) {
        this.setMetadata(metadata);
        return this;
    }

    public Map<String, EvaluationAnswerOutput> getAnswers() {
        return this.answers;
    }

    public void setAnswers(Map<String, EvaluationAnswerOutput> answers) {
        this.answers = answers;
    }

    public Evaluation withAnswers(Map<String, EvaluationAnswerOutput> answers) {
        this.setAnswers(answers);
        return this;
    }

    public Evaluation addAnswersEntry(String key, EvaluationAnswerOutput value) {
        if (null == this.answers) {
            this.answers = new HashMap<String, EvaluationAnswerOutput>();
        }
        if (this.answers.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.answers.put(key, value);
        return this;
    }

    public Evaluation clearAnswersEntries() {
        this.answers = null;
        return this;
    }

    public Map<String, EvaluationNote> getNotes() {
        return this.notes;
    }

    public void setNotes(Map<String, EvaluationNote> notes) {
        this.notes = notes;
    }

    public Evaluation withNotes(Map<String, EvaluationNote> notes) {
        this.setNotes(notes);
        return this;
    }

    public Evaluation addNotesEntry(String key, EvaluationNote value) {
        if (null == this.notes) {
            this.notes = new HashMap<String, EvaluationNote>();
        }
        if (this.notes.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.notes.put(key, value);
        return this;
    }

    public Evaluation clearNotesEntries() {
        this.notes = null;
        return this;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getStatus() {
        return this.status;
    }

    public Evaluation withStatus(String status) {
        this.setStatus(status);
        return this;
    }

    public Evaluation withStatus(EvaluationStatus status) {
        this.status = status.toString();
        return this;
    }

    public Map<String, EvaluationScore> getScores() {
        return this.scores;
    }

    public void setScores(Map<String, EvaluationScore> scores) {
        this.scores = scores;
    }

    public Evaluation withScores(Map<String, EvaluationScore> scores) {
        this.setScores(scores);
        return this;
    }

    public Evaluation addScoresEntry(String key, EvaluationScore value) {
        if (null == this.scores) {
            this.scores = new HashMap<String, EvaluationScore>();
        }
        if (this.scores.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.scores.put(key, value);
        return this;
    }

    public Evaluation clearScoresEntries() {
        this.scores = null;
        return this;
    }

    public void setCreatedTime(Date createdTime) {
        this.createdTime = createdTime;
    }

    public Date getCreatedTime() {
        return this.createdTime;
    }

    public Evaluation withCreatedTime(Date createdTime) {
        this.setCreatedTime(createdTime);
        return this;
    }

    public void setLastModifiedTime(Date lastModifiedTime) {
        this.lastModifiedTime = lastModifiedTime;
    }

    public Date getLastModifiedTime() {
        return this.lastModifiedTime;
    }

    public Evaluation withLastModifiedTime(Date lastModifiedTime) {
        this.setLastModifiedTime(lastModifiedTime);
        return this;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public void setTags(Map<String, String> tags) {
        this.tags = tags;
    }

    public Evaluation withTags(Map<String, String> tags) {
        this.setTags(tags);
        return this;
    }

    public Evaluation addTagsEntry(String key, String value) {
        if (null == this.tags) {
            this.tags = new HashMap<String, String>();
        }
        if (this.tags.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.tags.put(key, value);
        return this;
    }

    public Evaluation clearTagsEntries() {
        this.tags = null;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getEvaluationId() != null) {
            sb.append("EvaluationId: ").append(this.getEvaluationId()).append(",");
        }
        if (this.getEvaluationArn() != null) {
            sb.append("EvaluationArn: ").append(this.getEvaluationArn()).append(",");
        }
        if (this.getMetadata() != null) {
            sb.append("Metadata: ").append(this.getMetadata()).append(",");
        }
        if (this.getAnswers() != null) {
            sb.append("Answers: ").append(this.getAnswers()).append(",");
        }
        if (this.getNotes() != null) {
            sb.append("Notes: ").append(this.getNotes()).append(",");
        }
        if (this.getStatus() != null) {
            sb.append("Status: ").append(this.getStatus()).append(",");
        }
        if (this.getScores() != null) {
            sb.append("Scores: ").append(this.getScores()).append(",");
        }
        if (this.getCreatedTime() != null) {
            sb.append("CreatedTime: ").append(this.getCreatedTime()).append(",");
        }
        if (this.getLastModifiedTime() != null) {
            sb.append("LastModifiedTime: ").append(this.getLastModifiedTime()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Evaluation)) {
            return false;
        }
        Evaluation other = (Evaluation)obj;
        if (other.getEvaluationId() == null ^ this.getEvaluationId() == null) {
            return false;
        }
        if (other.getEvaluationId() != null && !other.getEvaluationId().equals(this.getEvaluationId())) {
            return false;
        }
        if (other.getEvaluationArn() == null ^ this.getEvaluationArn() == null) {
            return false;
        }
        if (other.getEvaluationArn() != null && !other.getEvaluationArn().equals(this.getEvaluationArn())) {
            return false;
        }
        if (other.getMetadata() == null ^ this.getMetadata() == null) {
            return false;
        }
        if (other.getMetadata() != null && !other.getMetadata().equals(this.getMetadata())) {
            return false;
        }
        if (other.getAnswers() == null ^ this.getAnswers() == null) {
            return false;
        }
        if (other.getAnswers() != null && !other.getAnswers().equals(this.getAnswers())) {
            return false;
        }
        if (other.getNotes() == null ^ this.getNotes() == null) {
            return false;
        }
        if (other.getNotes() != null && !other.getNotes().equals(this.getNotes())) {
            return false;
        }
        if (other.getStatus() == null ^ this.getStatus() == null) {
            return false;
        }
        if (other.getStatus() != null && !other.getStatus().equals(this.getStatus())) {
            return false;
        }
        if (other.getScores() == null ^ this.getScores() == null) {
            return false;
        }
        if (other.getScores() != null && !other.getScores().equals(this.getScores())) {
            return false;
        }
        if (other.getCreatedTime() == null ^ this.getCreatedTime() == null) {
            return false;
        }
        if (other.getCreatedTime() != null && !other.getCreatedTime().equals(this.getCreatedTime())) {
            return false;
        }
        if (other.getLastModifiedTime() == null ^ this.getLastModifiedTime() == null) {
            return false;
        }
        if (other.getLastModifiedTime() != null && !other.getLastModifiedTime().equals(this.getLastModifiedTime())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        return other.getTags() == null || other.getTags().equals(this.getTags());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getEvaluationId() == null ? 0 : this.getEvaluationId().hashCode());
        hashCode = 31 * hashCode + (this.getEvaluationArn() == null ? 0 : this.getEvaluationArn().hashCode());
        hashCode = 31 * hashCode + (this.getMetadata() == null ? 0 : this.getMetadata().hashCode());
        hashCode = 31 * hashCode + (this.getAnswers() == null ? 0 : this.getAnswers().hashCode());
        hashCode = 31 * hashCode + (this.getNotes() == null ? 0 : this.getNotes().hashCode());
        hashCode = 31 * hashCode + (this.getStatus() == null ? 0 : this.getStatus().hashCode());
        hashCode = 31 * hashCode + (this.getScores() == null ? 0 : this.getScores().hashCode());
        hashCode = 31 * hashCode + (this.getCreatedTime() == null ? 0 : this.getCreatedTime().hashCode());
        hashCode = 31 * hashCode + (this.getLastModifiedTime() == null ? 0 : this.getLastModifiedTime().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        return hashCode;
    }

    public Evaluation clone() {
        try {
            return (Evaluation)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        EvaluationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

