/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.connect.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.connect.model.ChatStreamingConfiguration;
import com.amazonaws.services.connect.model.ParticipantDetails;
import com.amazonaws.services.connect.model.transform.NewSessionDetailsMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class NewSessionDetails
implements Serializable,
Cloneable,
StructuredPojo {
    private List<String> supportedMessagingContentTypes;
    private ParticipantDetails participantDetails;
    private Map<String, String> attributes;
    private ChatStreamingConfiguration streamingConfiguration;

    public List<String> getSupportedMessagingContentTypes() {
        return this.supportedMessagingContentTypes;
    }

    public void setSupportedMessagingContentTypes(Collection<String> supportedMessagingContentTypes) {
        if (supportedMessagingContentTypes == null) {
            this.supportedMessagingContentTypes = null;
            return;
        }
        this.supportedMessagingContentTypes = new ArrayList<String>(supportedMessagingContentTypes);
    }

    public NewSessionDetails withSupportedMessagingContentTypes(String ... supportedMessagingContentTypes) {
        if (this.supportedMessagingContentTypes == null) {
            this.setSupportedMessagingContentTypes(new ArrayList<String>(supportedMessagingContentTypes.length));
        }
        for (String ele : supportedMessagingContentTypes) {
            this.supportedMessagingContentTypes.add(ele);
        }
        return this;
    }

    public NewSessionDetails withSupportedMessagingContentTypes(Collection<String> supportedMessagingContentTypes) {
        this.setSupportedMessagingContentTypes(supportedMessagingContentTypes);
        return this;
    }

    public void setParticipantDetails(ParticipantDetails participantDetails) {
        this.participantDetails = participantDetails;
    }

    public ParticipantDetails getParticipantDetails() {
        return this.participantDetails;
    }

    public NewSessionDetails withParticipantDetails(ParticipantDetails participantDetails) {
        this.setParticipantDetails(participantDetails);
        return this;
    }

    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(Map<String, String> attributes) {
        this.attributes = attributes;
    }

    public NewSessionDetails withAttributes(Map<String, String> attributes) {
        this.setAttributes(attributes);
        return this;
    }

    public NewSessionDetails addAttributesEntry(String key, String value) {
        if (null == this.attributes) {
            this.attributes = new HashMap<String, String>();
        }
        if (this.attributes.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.attributes.put(key, value);
        return this;
    }

    public NewSessionDetails clearAttributesEntries() {
        this.attributes = null;
        return this;
    }

    public void setStreamingConfiguration(ChatStreamingConfiguration streamingConfiguration) {
        this.streamingConfiguration = streamingConfiguration;
    }

    public ChatStreamingConfiguration getStreamingConfiguration() {
        return this.streamingConfiguration;
    }

    public NewSessionDetails withStreamingConfiguration(ChatStreamingConfiguration streamingConfiguration) {
        this.setStreamingConfiguration(streamingConfiguration);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getSupportedMessagingContentTypes() != null) {
            sb.append("SupportedMessagingContentTypes: ").append(this.getSupportedMessagingContentTypes()).append(",");
        }
        if (this.getParticipantDetails() != null) {
            sb.append("ParticipantDetails: ").append(this.getParticipantDetails()).append(",");
        }
        if (this.getAttributes() != null) {
            sb.append("Attributes: ").append(this.getAttributes()).append(",");
        }
        if (this.getStreamingConfiguration() != null) {
            sb.append("StreamingConfiguration: ").append(this.getStreamingConfiguration());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NewSessionDetails)) {
            return false;
        }
        NewSessionDetails other = (NewSessionDetails)obj;
        if (other.getSupportedMessagingContentTypes() == null ^ this.getSupportedMessagingContentTypes() == null) {
            return false;
        }
        if (other.getSupportedMessagingContentTypes() != null && !other.getSupportedMessagingContentTypes().equals(this.getSupportedMessagingContentTypes())) {
            return false;
        }
        if (other.getParticipantDetails() == null ^ this.getParticipantDetails() == null) {
            return false;
        }
        if (other.getParticipantDetails() != null && !other.getParticipantDetails().equals(this.getParticipantDetails())) {
            return false;
        }
        if (other.getAttributes() == null ^ this.getAttributes() == null) {
            return false;
        }
        if (other.getAttributes() != null && !other.getAttributes().equals(this.getAttributes())) {
            return false;
        }
        if (other.getStreamingConfiguration() == null ^ this.getStreamingConfiguration() == null) {
            return false;
        }
        return other.getStreamingConfiguration() == null || other.getStreamingConfiguration().equals(this.getStreamingConfiguration());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getSupportedMessagingContentTypes() == null ? 0 : this.getSupportedMessagingContentTypes().hashCode());
        hashCode = 31 * hashCode + (this.getParticipantDetails() == null ? 0 : this.getParticipantDetails().hashCode());
        hashCode = 31 * hashCode + (this.getAttributes() == null ? 0 : this.getAttributes().hashCode());
        hashCode = 31 * hashCode + (this.getStreamingConfiguration() == null ? 0 : this.getStreamingConfiguration().hashCode());
        return hashCode;
    }

    public NewSessionDetails clone() {
        try {
            return (NewSessionDetails)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        NewSessionDetailsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

