/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.connect.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.connect.model.SearchContactsMatchType;
import com.amazonaws.services.connect.model.TranscriptCriteria;
import com.amazonaws.services.connect.model.transform.TranscriptMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class Transcript
implements Serializable,
Cloneable,
StructuredPojo {
    private List<TranscriptCriteria> criteria;
    private String matchType;

    public List<TranscriptCriteria> getCriteria() {
        return this.criteria;
    }

    public void setCriteria(Collection<TranscriptCriteria> criteria) {
        if (criteria == null) {
            this.criteria = null;
            return;
        }
        this.criteria = new ArrayList<TranscriptCriteria>(criteria);
    }

    public Transcript withCriteria(TranscriptCriteria ... criteria) {
        if (this.criteria == null) {
            this.setCriteria(new ArrayList<TranscriptCriteria>(criteria.length));
        }
        for (TranscriptCriteria ele : criteria) {
            this.criteria.add(ele);
        }
        return this;
    }

    public Transcript withCriteria(Collection<TranscriptCriteria> criteria) {
        this.setCriteria(criteria);
        return this;
    }

    public void setMatchType(String matchType) {
        this.matchType = matchType;
    }

    public String getMatchType() {
        return this.matchType;
    }

    public Transcript withMatchType(String matchType) {
        this.setMatchType(matchType);
        return this;
    }

    public Transcript withMatchType(SearchContactsMatchType matchType) {
        this.matchType = matchType.toString();
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getCriteria() != null) {
            sb.append("Criteria: ").append(this.getCriteria()).append(",");
        }
        if (this.getMatchType() != null) {
            sb.append("MatchType: ").append(this.getMatchType());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Transcript)) {
            return false;
        }
        Transcript other = (Transcript)obj;
        if (other.getCriteria() == null ^ this.getCriteria() == null) {
            return false;
        }
        if (other.getCriteria() != null && !other.getCriteria().equals(this.getCriteria())) {
            return false;
        }
        if (other.getMatchType() == null ^ this.getMatchType() == null) {
            return false;
        }
        return other.getMatchType() == null || other.getMatchType().equals(this.getMatchType());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getCriteria() == null ? 0 : this.getCriteria().hashCode());
        hashCode = 31 * hashCode + (this.getMatchType() == null ? 0 : this.getMatchType().hashCode());
        return hashCode;
    }

    public Transcript clone() {
        try {
            return (Transcript)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        TranscriptMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

