/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.connect.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.connect.model.Reference;
import com.amazonaws.services.connect.model.transform.TaskActionDefinitionMarshaller;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class TaskActionDefinition
implements Serializable,
Cloneable,
StructuredPojo {
    private String name;
    private String description;
    private String contactFlowId;
    private Map<String, Reference> references;

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public TaskActionDefinition withName(String name) {
        this.setName(name);
        return this;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public TaskActionDefinition withDescription(String description) {
        this.setDescription(description);
        return this;
    }

    public void setContactFlowId(String contactFlowId) {
        this.contactFlowId = contactFlowId;
    }

    public String getContactFlowId() {
        return this.contactFlowId;
    }

    public TaskActionDefinition withContactFlowId(String contactFlowId) {
        this.setContactFlowId(contactFlowId);
        return this;
    }

    public Map<String, Reference> getReferences() {
        return this.references;
    }

    public void setReferences(Map<String, Reference> references) {
        this.references = references;
    }

    public TaskActionDefinition withReferences(Map<String, Reference> references) {
        this.setReferences(references);
        return this;
    }

    public TaskActionDefinition addReferencesEntry(String key, Reference value) {
        if (null == this.references) {
            this.references = new HashMap<String, Reference>();
        }
        if (this.references.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.references.put(key, value);
        return this;
    }

    public TaskActionDefinition clearReferencesEntries() {
        this.references = null;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getDescription() != null) {
            sb.append("Description: ").append(this.getDescription()).append(",");
        }
        if (this.getContactFlowId() != null) {
            sb.append("ContactFlowId: ").append(this.getContactFlowId()).append(",");
        }
        if (this.getReferences() != null) {
            sb.append("References: ").append(this.getReferences());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TaskActionDefinition)) {
            return false;
        }
        TaskActionDefinition other = (TaskActionDefinition)obj;
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        if (other.getDescription() != null && !other.getDescription().equals(this.getDescription())) {
            return false;
        }
        if (other.getContactFlowId() == null ^ this.getContactFlowId() == null) {
            return false;
        }
        if (other.getContactFlowId() != null && !other.getContactFlowId().equals(this.getContactFlowId())) {
            return false;
        }
        if (other.getReferences() == null ^ this.getReferences() == null) {
            return false;
        }
        return other.getReferences() == null || other.getReferences().equals(this.getReferences());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        hashCode = 31 * hashCode + (this.getContactFlowId() == null ? 0 : this.getContactFlowId().hashCode());
        hashCode = 31 * hashCode + (this.getReferences() == null ? 0 : this.getReferences().hashCode());
        return hashCode;
    }

    public TaskActionDefinition clone() {
        try {
            return (TaskActionDefinition)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        TaskActionDefinitionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

