/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.connect.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.connect.model.AttributeCondition;
import com.amazonaws.services.connect.model.transform.ExpressionMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class Expression
implements Serializable,
Cloneable,
StructuredPojo {
    private AttributeCondition attributeCondition;
    private List<Expression> andExpression;
    private List<Expression> orExpression;

    public void setAttributeCondition(AttributeCondition attributeCondition) {
        this.attributeCondition = attributeCondition;
    }

    public AttributeCondition getAttributeCondition() {
        return this.attributeCondition;
    }

    public Expression withAttributeCondition(AttributeCondition attributeCondition) {
        this.setAttributeCondition(attributeCondition);
        return this;
    }

    public List<Expression> getAndExpression() {
        return this.andExpression;
    }

    public void setAndExpression(Collection<Expression> andExpression) {
        if (andExpression == null) {
            this.andExpression = null;
            return;
        }
        this.andExpression = new ArrayList<Expression>(andExpression);
    }

    public Expression withAndExpression(Expression ... andExpression) {
        if (this.andExpression == null) {
            this.setAndExpression(new ArrayList<Expression>(andExpression.length));
        }
        for (Expression ele : andExpression) {
            this.andExpression.add(ele);
        }
        return this;
    }

    public Expression withAndExpression(Collection<Expression> andExpression) {
        this.setAndExpression(andExpression);
        return this;
    }

    public List<Expression> getOrExpression() {
        return this.orExpression;
    }

    public void setOrExpression(Collection<Expression> orExpression) {
        if (orExpression == null) {
            this.orExpression = null;
            return;
        }
        this.orExpression = new ArrayList<Expression>(orExpression);
    }

    public Expression withOrExpression(Expression ... orExpression) {
        if (this.orExpression == null) {
            this.setOrExpression(new ArrayList<Expression>(orExpression.length));
        }
        for (Expression ele : orExpression) {
            this.orExpression.add(ele);
        }
        return this;
    }

    public Expression withOrExpression(Collection<Expression> orExpression) {
        this.setOrExpression(orExpression);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAttributeCondition() != null) {
            sb.append("AttributeCondition: ").append(this.getAttributeCondition()).append(",");
        }
        if (this.getAndExpression() != null) {
            sb.append("AndExpression: ").append(this.getAndExpression()).append(",");
        }
        if (this.getOrExpression() != null) {
            sb.append("OrExpression: ").append(this.getOrExpression());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Expression)) {
            return false;
        }
        Expression other = (Expression)obj;
        if (other.getAttributeCondition() == null ^ this.getAttributeCondition() == null) {
            return false;
        }
        if (other.getAttributeCondition() != null && !other.getAttributeCondition().equals(this.getAttributeCondition())) {
            return false;
        }
        if (other.getAndExpression() == null ^ this.getAndExpression() == null) {
            return false;
        }
        if (other.getAndExpression() != null && !other.getAndExpression().equals(this.getAndExpression())) {
            return false;
        }
        if (other.getOrExpression() == null ^ this.getOrExpression() == null) {
            return false;
        }
        return other.getOrExpression() == null || other.getOrExpression().equals(this.getOrExpression());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAttributeCondition() == null ? 0 : this.getAttributeCondition().hashCode());
        hashCode = 31 * hashCode + (this.getAndExpression() == null ? 0 : this.getAndExpression().hashCode());
        hashCode = 31 * hashCode + (this.getOrExpression() == null ? 0 : this.getOrExpression().hashCode());
        return hashCode;
    }

    public Expression clone() {
        try {
            return (Expression)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ExpressionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

