/*
 * Copyright 2020-2025 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.connect.model;

import java.io.Serializable;
import javax.annotation.Generated;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.protocol.ProtocolMarshaller;

/**
 * <p>
 * A structure that defines the field name to sort by and a sort order.
 * </p>
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/Sort" target="_top">AWS API Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class Sort implements Serializable, Cloneable, StructuredPojo {

    /**
     * <p>
     * The name of the field on which to sort.
     * </p>
     */
    private String fieldName;
    /**
     * <p>
     * An ascending or descending sort.
     * </p>
     */
    private String order;

    /**
     * <p>
     * The name of the field on which to sort.
     * </p>
     * 
     * @param fieldName
     *        The name of the field on which to sort.
     * @see SortableFieldName
     */

    public void setFieldName(String fieldName) {
        this.fieldName = fieldName;
    }

    /**
     * <p>
     * The name of the field on which to sort.
     * </p>
     * 
     * @return The name of the field on which to sort.
     * @see SortableFieldName
     */

    public String getFieldName() {
        return this.fieldName;
    }

    /**
     * <p>
     * The name of the field on which to sort.
     * </p>
     * 
     * @param fieldName
     *        The name of the field on which to sort.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see SortableFieldName
     */

    public Sort withFieldName(String fieldName) {
        setFieldName(fieldName);
        return this;
    }

    /**
     * <p>
     * The name of the field on which to sort.
     * </p>
     * 
     * @param fieldName
     *        The name of the field on which to sort.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see SortableFieldName
     */

    public Sort withFieldName(SortableFieldName fieldName) {
        this.fieldName = fieldName.toString();
        return this;
    }

    /**
     * <p>
     * An ascending or descending sort.
     * </p>
     * 
     * @param order
     *        An ascending or descending sort.
     * @see SortOrder
     */

    public void setOrder(String order) {
        this.order = order;
    }

    /**
     * <p>
     * An ascending or descending sort.
     * </p>
     * 
     * @return An ascending or descending sort.
     * @see SortOrder
     */

    public String getOrder() {
        return this.order;
    }

    /**
     * <p>
     * An ascending or descending sort.
     * </p>
     * 
     * @param order
     *        An ascending or descending sort.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see SortOrder
     */

    public Sort withOrder(String order) {
        setOrder(order);
        return this;
    }

    /**
     * <p>
     * An ascending or descending sort.
     * </p>
     * 
     * @param order
     *        An ascending or descending sort.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see SortOrder
     */

    public Sort withOrder(SortOrder order) {
        this.order = order.toString();
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getFieldName() != null)
            sb.append("FieldName: ").append(getFieldName()).append(",");
        if (getOrder() != null)
            sb.append("Order: ").append(getOrder());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof Sort == false)
            return false;
        Sort other = (Sort) obj;
        if (other.getFieldName() == null ^ this.getFieldName() == null)
            return false;
        if (other.getFieldName() != null && other.getFieldName().equals(this.getFieldName()) == false)
            return false;
        if (other.getOrder() == null ^ this.getOrder() == null)
            return false;
        if (other.getOrder() != null && other.getOrder().equals(this.getOrder()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getFieldName() == null) ? 0 : getFieldName().hashCode());
        hashCode = prime * hashCode + ((getOrder() == null) ? 0 : getOrder().hashCode());
        return hashCode;
    }

    @Override
    public Sort clone() {
        try {
            return (Sort) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

    @com.amazonaws.annotation.SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        com.amazonaws.services.connect.model.transform.SortMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}
