/*
 * Copyright 2019-2024 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.connect.model;

import java.io.Serializable;
import javax.annotation.Generated;

import com.amazonaws.AmazonWebServiceRequest;

/**
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/MonitorContact" target="_top">AWS API
 *      Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class MonitorContactRequest extends com.amazonaws.AmazonWebServiceRequest implements Serializable, Cloneable {

    /**
     * <p>
     * The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.
     * </p>
     */
    private String instanceId;
    /**
     * <p>
     * The identifier of the contact.
     * </p>
     */
    private String contactId;
    /**
     * <p>
     * The identifier of the user account.
     * </p>
     */
    private String userId;
    /**
     * <p>
     * Specify which monitoring actions the user is allowed to take. For example, whether the user is allowed to
     * escalate from silent monitoring to barge. AllowedMonitorCapabilities is required if barge is enabled.
     * </p>
     */
    private java.util.List<String> allowedMonitorCapabilities;
    /**
     * <p>
     * A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If not provided,
     * the Amazon Web Services SDK populates this field. For more information about idempotency, see <a
     * href="https://aws.amazon.com/builders-library/making-retries-safe-with-idempotent-APIs/">Making retries safe with
     * idempotent APIs</a>.
     * </p>
     */
    private String clientToken;

    /**
     * <p>
     * The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.
     * </p>
     * 
     * @param instanceId
     *        The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.
     */

    public void setInstanceId(String instanceId) {
        this.instanceId = instanceId;
    }

    /**
     * <p>
     * The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.
     * </p>
     * 
     * @return The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.
     */

    public String getInstanceId() {
        return this.instanceId;
    }

    /**
     * <p>
     * The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.
     * </p>
     * 
     * @param instanceId
     *        The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public MonitorContactRequest withInstanceId(String instanceId) {
        setInstanceId(instanceId);
        return this;
    }

    /**
     * <p>
     * The identifier of the contact.
     * </p>
     * 
     * @param contactId
     *        The identifier of the contact.
     */

    public void setContactId(String contactId) {
        this.contactId = contactId;
    }

    /**
     * <p>
     * The identifier of the contact.
     * </p>
     * 
     * @return The identifier of the contact.
     */

    public String getContactId() {
        return this.contactId;
    }

    /**
     * <p>
     * The identifier of the contact.
     * </p>
     * 
     * @param contactId
     *        The identifier of the contact.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public MonitorContactRequest withContactId(String contactId) {
        setContactId(contactId);
        return this;
    }

    /**
     * <p>
     * The identifier of the user account.
     * </p>
     * 
     * @param userId
     *        The identifier of the user account.
     */

    public void setUserId(String userId) {
        this.userId = userId;
    }

    /**
     * <p>
     * The identifier of the user account.
     * </p>
     * 
     * @return The identifier of the user account.
     */

    public String getUserId() {
        return this.userId;
    }

    /**
     * <p>
     * The identifier of the user account.
     * </p>
     * 
     * @param userId
     *        The identifier of the user account.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public MonitorContactRequest withUserId(String userId) {
        setUserId(userId);
        return this;
    }

    /**
     * <p>
     * Specify which monitoring actions the user is allowed to take. For example, whether the user is allowed to
     * escalate from silent monitoring to barge. AllowedMonitorCapabilities is required if barge is enabled.
     * </p>
     * 
     * @return Specify which monitoring actions the user is allowed to take. For example, whether the user is allowed to
     *         escalate from silent monitoring to barge. AllowedMonitorCapabilities is required if barge is enabled.
     * @see MonitorCapability
     */

    public java.util.List<String> getAllowedMonitorCapabilities() {
        return allowedMonitorCapabilities;
    }

    /**
     * <p>
     * Specify which monitoring actions the user is allowed to take. For example, whether the user is allowed to
     * escalate from silent monitoring to barge. AllowedMonitorCapabilities is required if barge is enabled.
     * </p>
     * 
     * @param allowedMonitorCapabilities
     *        Specify which monitoring actions the user is allowed to take. For example, whether the user is allowed to
     *        escalate from silent monitoring to barge. AllowedMonitorCapabilities is required if barge is enabled.
     * @see MonitorCapability
     */

    public void setAllowedMonitorCapabilities(java.util.Collection<String> allowedMonitorCapabilities) {
        if (allowedMonitorCapabilities == null) {
            this.allowedMonitorCapabilities = null;
            return;
        }

        this.allowedMonitorCapabilities = new java.util.ArrayList<String>(allowedMonitorCapabilities);
    }

    /**
     * <p>
     * Specify which monitoring actions the user is allowed to take. For example, whether the user is allowed to
     * escalate from silent monitoring to barge. AllowedMonitorCapabilities is required if barge is enabled.
     * </p>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setAllowedMonitorCapabilities(java.util.Collection)} or
     * {@link #withAllowedMonitorCapabilities(java.util.Collection)} if you want to override the existing values.
     * </p>
     * 
     * @param allowedMonitorCapabilities
     *        Specify which monitoring actions the user is allowed to take. For example, whether the user is allowed to
     *        escalate from silent monitoring to barge. AllowedMonitorCapabilities is required if barge is enabled.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see MonitorCapability
     */

    public MonitorContactRequest withAllowedMonitorCapabilities(String... allowedMonitorCapabilities) {
        if (this.allowedMonitorCapabilities == null) {
            setAllowedMonitorCapabilities(new java.util.ArrayList<String>(allowedMonitorCapabilities.length));
        }
        for (String ele : allowedMonitorCapabilities) {
            this.allowedMonitorCapabilities.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * Specify which monitoring actions the user is allowed to take. For example, whether the user is allowed to
     * escalate from silent monitoring to barge. AllowedMonitorCapabilities is required if barge is enabled.
     * </p>
     * 
     * @param allowedMonitorCapabilities
     *        Specify which monitoring actions the user is allowed to take. For example, whether the user is allowed to
     *        escalate from silent monitoring to barge. AllowedMonitorCapabilities is required if barge is enabled.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see MonitorCapability
     */

    public MonitorContactRequest withAllowedMonitorCapabilities(java.util.Collection<String> allowedMonitorCapabilities) {
        setAllowedMonitorCapabilities(allowedMonitorCapabilities);
        return this;
    }

    /**
     * <p>
     * Specify which monitoring actions the user is allowed to take. For example, whether the user is allowed to
     * escalate from silent monitoring to barge. AllowedMonitorCapabilities is required if barge is enabled.
     * </p>
     * 
     * @param allowedMonitorCapabilities
     *        Specify which monitoring actions the user is allowed to take. For example, whether the user is allowed to
     *        escalate from silent monitoring to barge. AllowedMonitorCapabilities is required if barge is enabled.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see MonitorCapability
     */

    public MonitorContactRequest withAllowedMonitorCapabilities(MonitorCapability... allowedMonitorCapabilities) {
        java.util.ArrayList<String> allowedMonitorCapabilitiesCopy = new java.util.ArrayList<String>(allowedMonitorCapabilities.length);
        for (MonitorCapability value : allowedMonitorCapabilities) {
            allowedMonitorCapabilitiesCopy.add(value.toString());
        }
        if (getAllowedMonitorCapabilities() == null) {
            setAllowedMonitorCapabilities(allowedMonitorCapabilitiesCopy);
        } else {
            getAllowedMonitorCapabilities().addAll(allowedMonitorCapabilitiesCopy);
        }
        return this;
    }

    /**
     * <p>
     * A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If not provided,
     * the Amazon Web Services SDK populates this field. For more information about idempotency, see <a
     * href="https://aws.amazon.com/builders-library/making-retries-safe-with-idempotent-APIs/">Making retries safe with
     * idempotent APIs</a>.
     * </p>
     * 
     * @param clientToken
     *        A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If not
     *        provided, the Amazon Web Services SDK populates this field. For more information about idempotency, see <a
     *        href="https://aws.amazon.com/builders-library/making-retries-safe-with-idempotent-APIs/">Making retries
     *        safe with idempotent APIs</a>.
     */

    public void setClientToken(String clientToken) {
        this.clientToken = clientToken;
    }

    /**
     * <p>
     * A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If not provided,
     * the Amazon Web Services SDK populates this field. For more information about idempotency, see <a
     * href="https://aws.amazon.com/builders-library/making-retries-safe-with-idempotent-APIs/">Making retries safe with
     * idempotent APIs</a>.
     * </p>
     * 
     * @return A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If not
     *         provided, the Amazon Web Services SDK populates this field. For more information about idempotency, see
     *         <a href="https://aws.amazon.com/builders-library/making-retries-safe-with-idempotent-APIs/">Making
     *         retries safe with idempotent APIs</a>.
     */

    public String getClientToken() {
        return this.clientToken;
    }

    /**
     * <p>
     * A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If not provided,
     * the Amazon Web Services SDK populates this field. For more information about idempotency, see <a
     * href="https://aws.amazon.com/builders-library/making-retries-safe-with-idempotent-APIs/">Making retries safe with
     * idempotent APIs</a>.
     * </p>
     * 
     * @param clientToken
     *        A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If not
     *        provided, the Amazon Web Services SDK populates this field. For more information about idempotency, see <a
     *        href="https://aws.amazon.com/builders-library/making-retries-safe-with-idempotent-APIs/">Making retries
     *        safe with idempotent APIs</a>.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public MonitorContactRequest withClientToken(String clientToken) {
        setClientToken(clientToken);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getInstanceId() != null)
            sb.append("InstanceId: ").append(getInstanceId()).append(",");
        if (getContactId() != null)
            sb.append("ContactId: ").append(getContactId()).append(",");
        if (getUserId() != null)
            sb.append("UserId: ").append(getUserId()).append(",");
        if (getAllowedMonitorCapabilities() != null)
            sb.append("AllowedMonitorCapabilities: ").append(getAllowedMonitorCapabilities()).append(",");
        if (getClientToken() != null)
            sb.append("ClientToken: ").append(getClientToken());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof MonitorContactRequest == false)
            return false;
        MonitorContactRequest other = (MonitorContactRequest) obj;
        if (other.getInstanceId() == null ^ this.getInstanceId() == null)
            return false;
        if (other.getInstanceId() != null && other.getInstanceId().equals(this.getInstanceId()) == false)
            return false;
        if (other.getContactId() == null ^ this.getContactId() == null)
            return false;
        if (other.getContactId() != null && other.getContactId().equals(this.getContactId()) == false)
            return false;
        if (other.getUserId() == null ^ this.getUserId() == null)
            return false;
        if (other.getUserId() != null && other.getUserId().equals(this.getUserId()) == false)
            return false;
        if (other.getAllowedMonitorCapabilities() == null ^ this.getAllowedMonitorCapabilities() == null)
            return false;
        if (other.getAllowedMonitorCapabilities() != null && other.getAllowedMonitorCapabilities().equals(this.getAllowedMonitorCapabilities()) == false)
            return false;
        if (other.getClientToken() == null ^ this.getClientToken() == null)
            return false;
        if (other.getClientToken() != null && other.getClientToken().equals(this.getClientToken()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getInstanceId() == null) ? 0 : getInstanceId().hashCode());
        hashCode = prime * hashCode + ((getContactId() == null) ? 0 : getContactId().hashCode());
        hashCode = prime * hashCode + ((getUserId() == null) ? 0 : getUserId().hashCode());
        hashCode = prime * hashCode + ((getAllowedMonitorCapabilities() == null) ? 0 : getAllowedMonitorCapabilities().hashCode());
        hashCode = prime * hashCode + ((getClientToken() == null) ? 0 : getClientToken().hashCode());
        return hashCode;
    }

    @Override
    public MonitorContactRequest clone() {
        return (MonitorContactRequest) super.clone();
    }

}
