/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.connect.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.connect.model.PhoneNumberCountryCode;
import com.amazonaws.services.connect.model.PhoneNumberType;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ListPhoneNumbersV2Request
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String targetArn;
    private Integer maxResults;
    private String nextToken;
    private List<String> phoneNumberCountryCodes;
    private List<String> phoneNumberTypes;
    private String phoneNumberPrefix;

    public void setTargetArn(String targetArn) {
        this.targetArn = targetArn;
    }

    public String getTargetArn() {
        return this.targetArn;
    }

    public ListPhoneNumbersV2Request withTargetArn(String targetArn) {
        this.setTargetArn(targetArn);
        return this;
    }

    public void setMaxResults(Integer maxResults) {
        this.maxResults = maxResults;
    }

    public Integer getMaxResults() {
        return this.maxResults;
    }

    public ListPhoneNumbersV2Request withMaxResults(Integer maxResults) {
        this.setMaxResults(maxResults);
        return this;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public ListPhoneNumbersV2Request withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public List<String> getPhoneNumberCountryCodes() {
        return this.phoneNumberCountryCodes;
    }

    public void setPhoneNumberCountryCodes(Collection<String> phoneNumberCountryCodes) {
        if (phoneNumberCountryCodes == null) {
            this.phoneNumberCountryCodes = null;
            return;
        }
        this.phoneNumberCountryCodes = new ArrayList<String>(phoneNumberCountryCodes);
    }

    public ListPhoneNumbersV2Request withPhoneNumberCountryCodes(String ... phoneNumberCountryCodes) {
        if (this.phoneNumberCountryCodes == null) {
            this.setPhoneNumberCountryCodes(new ArrayList<String>(phoneNumberCountryCodes.length));
        }
        for (String ele : phoneNumberCountryCodes) {
            this.phoneNumberCountryCodes.add(ele);
        }
        return this;
    }

    public ListPhoneNumbersV2Request withPhoneNumberCountryCodes(Collection<String> phoneNumberCountryCodes) {
        this.setPhoneNumberCountryCodes(phoneNumberCountryCodes);
        return this;
    }

    public ListPhoneNumbersV2Request withPhoneNumberCountryCodes(PhoneNumberCountryCode ... phoneNumberCountryCodes) {
        ArrayList<String> phoneNumberCountryCodesCopy = new ArrayList<String>(phoneNumberCountryCodes.length);
        for (PhoneNumberCountryCode value : phoneNumberCountryCodes) {
            phoneNumberCountryCodesCopy.add(value.toString());
        }
        if (this.getPhoneNumberCountryCodes() == null) {
            this.setPhoneNumberCountryCodes(phoneNumberCountryCodesCopy);
        } else {
            this.getPhoneNumberCountryCodes().addAll(phoneNumberCountryCodesCopy);
        }
        return this;
    }

    public List<String> getPhoneNumberTypes() {
        return this.phoneNumberTypes;
    }

    public void setPhoneNumberTypes(Collection<String> phoneNumberTypes) {
        if (phoneNumberTypes == null) {
            this.phoneNumberTypes = null;
            return;
        }
        this.phoneNumberTypes = new ArrayList<String>(phoneNumberTypes);
    }

    public ListPhoneNumbersV2Request withPhoneNumberTypes(String ... phoneNumberTypes) {
        if (this.phoneNumberTypes == null) {
            this.setPhoneNumberTypes(new ArrayList<String>(phoneNumberTypes.length));
        }
        for (String ele : phoneNumberTypes) {
            this.phoneNumberTypes.add(ele);
        }
        return this;
    }

    public ListPhoneNumbersV2Request withPhoneNumberTypes(Collection<String> phoneNumberTypes) {
        this.setPhoneNumberTypes(phoneNumberTypes);
        return this;
    }

    public ListPhoneNumbersV2Request withPhoneNumberTypes(PhoneNumberType ... phoneNumberTypes) {
        ArrayList<String> phoneNumberTypesCopy = new ArrayList<String>(phoneNumberTypes.length);
        for (PhoneNumberType value : phoneNumberTypes) {
            phoneNumberTypesCopy.add(value.toString());
        }
        if (this.getPhoneNumberTypes() == null) {
            this.setPhoneNumberTypes(phoneNumberTypesCopy);
        } else {
            this.getPhoneNumberTypes().addAll(phoneNumberTypesCopy);
        }
        return this;
    }

    public void setPhoneNumberPrefix(String phoneNumberPrefix) {
        this.phoneNumberPrefix = phoneNumberPrefix;
    }

    public String getPhoneNumberPrefix() {
        return this.phoneNumberPrefix;
    }

    public ListPhoneNumbersV2Request withPhoneNumberPrefix(String phoneNumberPrefix) {
        this.setPhoneNumberPrefix(phoneNumberPrefix);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getTargetArn() != null) {
            sb.append("TargetArn: ").append(this.getTargetArn()).append(",");
        }
        if (this.getMaxResults() != null) {
            sb.append("MaxResults: ").append(this.getMaxResults()).append(",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken()).append(",");
        }
        if (this.getPhoneNumberCountryCodes() != null) {
            sb.append("PhoneNumberCountryCodes: ").append(this.getPhoneNumberCountryCodes()).append(",");
        }
        if (this.getPhoneNumberTypes() != null) {
            sb.append("PhoneNumberTypes: ").append(this.getPhoneNumberTypes()).append(",");
        }
        if (this.getPhoneNumberPrefix() != null) {
            sb.append("PhoneNumberPrefix: ").append(this.getPhoneNumberPrefix());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListPhoneNumbersV2Request)) {
            return false;
        }
        ListPhoneNumbersV2Request other = (ListPhoneNumbersV2Request)obj;
        if (other.getTargetArn() == null ^ this.getTargetArn() == null) {
            return false;
        }
        if (other.getTargetArn() != null && !other.getTargetArn().equals(this.getTargetArn())) {
            return false;
        }
        if (other.getMaxResults() == null ^ this.getMaxResults() == null) {
            return false;
        }
        if (other.getMaxResults() != null && !other.getMaxResults().equals(this.getMaxResults())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        if (other.getNextToken() != null && !other.getNextToken().equals(this.getNextToken())) {
            return false;
        }
        if (other.getPhoneNumberCountryCodes() == null ^ this.getPhoneNumberCountryCodes() == null) {
            return false;
        }
        if (other.getPhoneNumberCountryCodes() != null && !other.getPhoneNumberCountryCodes().equals(this.getPhoneNumberCountryCodes())) {
            return false;
        }
        if (other.getPhoneNumberTypes() == null ^ this.getPhoneNumberTypes() == null) {
            return false;
        }
        if (other.getPhoneNumberTypes() != null && !other.getPhoneNumberTypes().equals(this.getPhoneNumberTypes())) {
            return false;
        }
        if (other.getPhoneNumberPrefix() == null ^ this.getPhoneNumberPrefix() == null) {
            return false;
        }
        return other.getPhoneNumberPrefix() == null || other.getPhoneNumberPrefix().equals(this.getPhoneNumberPrefix());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getTargetArn() == null ? 0 : this.getTargetArn().hashCode());
        hashCode = 31 * hashCode + (this.getMaxResults() == null ? 0 : this.getMaxResults().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        hashCode = 31 * hashCode + (this.getPhoneNumberCountryCodes() == null ? 0 : this.getPhoneNumberCountryCodes().hashCode());
        hashCode = 31 * hashCode + (this.getPhoneNumberTypes() == null ? 0 : this.getPhoneNumberTypes().hashCode());
        hashCode = 31 * hashCode + (this.getPhoneNumberPrefix() == null ? 0 : this.getPhoneNumberPrefix().hashCode());
        return hashCode;
    }

    public ListPhoneNumbersV2Request clone() {
        return (ListPhoneNumbersV2Request)super.clone();
    }
}

