/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.connect.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.connect.model.MediaConcurrency;
import com.amazonaws.services.connect.model.RoutingProfileQueueConfig;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CreateRoutingProfileRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String instanceId;
    private String name;
    private String description;
    private String defaultOutboundQueueId;
    private List<RoutingProfileQueueConfig> queueConfigs;
    private List<MediaConcurrency> mediaConcurrencies;
    private Map<String, String> tags;

    public void setInstanceId(String instanceId) {
        this.instanceId = instanceId;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public CreateRoutingProfileRequest withInstanceId(String instanceId) {
        this.setInstanceId(instanceId);
        return this;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public CreateRoutingProfileRequest withName(String name) {
        this.setName(name);
        return this;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public CreateRoutingProfileRequest withDescription(String description) {
        this.setDescription(description);
        return this;
    }

    public void setDefaultOutboundQueueId(String defaultOutboundQueueId) {
        this.defaultOutboundQueueId = defaultOutboundQueueId;
    }

    public String getDefaultOutboundQueueId() {
        return this.defaultOutboundQueueId;
    }

    public CreateRoutingProfileRequest withDefaultOutboundQueueId(String defaultOutboundQueueId) {
        this.setDefaultOutboundQueueId(defaultOutboundQueueId);
        return this;
    }

    public List<RoutingProfileQueueConfig> getQueueConfigs() {
        return this.queueConfigs;
    }

    public void setQueueConfigs(Collection<RoutingProfileQueueConfig> queueConfigs) {
        if (queueConfigs == null) {
            this.queueConfigs = null;
            return;
        }
        this.queueConfigs = new ArrayList<RoutingProfileQueueConfig>(queueConfigs);
    }

    public CreateRoutingProfileRequest withQueueConfigs(RoutingProfileQueueConfig ... queueConfigs) {
        if (this.queueConfigs == null) {
            this.setQueueConfigs(new ArrayList<RoutingProfileQueueConfig>(queueConfigs.length));
        }
        for (RoutingProfileQueueConfig ele : queueConfigs) {
            this.queueConfigs.add(ele);
        }
        return this;
    }

    public CreateRoutingProfileRequest withQueueConfigs(Collection<RoutingProfileQueueConfig> queueConfigs) {
        this.setQueueConfigs(queueConfigs);
        return this;
    }

    public List<MediaConcurrency> getMediaConcurrencies() {
        return this.mediaConcurrencies;
    }

    public void setMediaConcurrencies(Collection<MediaConcurrency> mediaConcurrencies) {
        if (mediaConcurrencies == null) {
            this.mediaConcurrencies = null;
            return;
        }
        this.mediaConcurrencies = new ArrayList<MediaConcurrency>(mediaConcurrencies);
    }

    public CreateRoutingProfileRequest withMediaConcurrencies(MediaConcurrency ... mediaConcurrencies) {
        if (this.mediaConcurrencies == null) {
            this.setMediaConcurrencies(new ArrayList<MediaConcurrency>(mediaConcurrencies.length));
        }
        for (MediaConcurrency ele : mediaConcurrencies) {
            this.mediaConcurrencies.add(ele);
        }
        return this;
    }

    public CreateRoutingProfileRequest withMediaConcurrencies(Collection<MediaConcurrency> mediaConcurrencies) {
        this.setMediaConcurrencies(mediaConcurrencies);
        return this;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public void setTags(Map<String, String> tags) {
        this.tags = tags;
    }

    public CreateRoutingProfileRequest withTags(Map<String, String> tags) {
        this.setTags(tags);
        return this;
    }

    public CreateRoutingProfileRequest addTagsEntry(String key, String value) {
        if (null == this.tags) {
            this.tags = new HashMap<String, String>();
        }
        if (this.tags.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.tags.put(key, value);
        return this;
    }

    public CreateRoutingProfileRequest clearTagsEntries() {
        this.tags = null;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getInstanceId() != null) {
            sb.append("InstanceId: ").append(this.getInstanceId()).append(",");
        }
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getDescription() != null) {
            sb.append("Description: ").append(this.getDescription()).append(",");
        }
        if (this.getDefaultOutboundQueueId() != null) {
            sb.append("DefaultOutboundQueueId: ").append(this.getDefaultOutboundQueueId()).append(",");
        }
        if (this.getQueueConfigs() != null) {
            sb.append("QueueConfigs: ").append(this.getQueueConfigs()).append(",");
        }
        if (this.getMediaConcurrencies() != null) {
            sb.append("MediaConcurrencies: ").append(this.getMediaConcurrencies()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateRoutingProfileRequest)) {
            return false;
        }
        CreateRoutingProfileRequest other = (CreateRoutingProfileRequest)obj;
        if (other.getInstanceId() == null ^ this.getInstanceId() == null) {
            return false;
        }
        if (other.getInstanceId() != null && !other.getInstanceId().equals(this.getInstanceId())) {
            return false;
        }
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        if (other.getDescription() != null && !other.getDescription().equals(this.getDescription())) {
            return false;
        }
        if (other.getDefaultOutboundQueueId() == null ^ this.getDefaultOutboundQueueId() == null) {
            return false;
        }
        if (other.getDefaultOutboundQueueId() != null && !other.getDefaultOutboundQueueId().equals(this.getDefaultOutboundQueueId())) {
            return false;
        }
        if (other.getQueueConfigs() == null ^ this.getQueueConfigs() == null) {
            return false;
        }
        if (other.getQueueConfigs() != null && !other.getQueueConfigs().equals(this.getQueueConfigs())) {
            return false;
        }
        if (other.getMediaConcurrencies() == null ^ this.getMediaConcurrencies() == null) {
            return false;
        }
        if (other.getMediaConcurrencies() != null && !other.getMediaConcurrencies().equals(this.getMediaConcurrencies())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        return other.getTags() == null || other.getTags().equals(this.getTags());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getInstanceId() == null ? 0 : this.getInstanceId().hashCode());
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        hashCode = 31 * hashCode + (this.getDefaultOutboundQueueId() == null ? 0 : this.getDefaultOutboundQueueId().hashCode());
        hashCode = 31 * hashCode + (this.getQueueConfigs() == null ? 0 : this.getQueueConfigs().hashCode());
        hashCode = 31 * hashCode + (this.getMediaConcurrencies() == null ? 0 : this.getMediaConcurrencies().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        return hashCode;
    }

    public CreateRoutingProfileRequest clone() {
        return (CreateRoutingProfileRequest)super.clone();
    }
}

