/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.config.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.config.model.Tag;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class PutAggregationAuthorizationRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String authorizedAccountId;
    private String authorizedAwsRegion;
    private SdkInternalList<Tag> tags;

    public void setAuthorizedAccountId(String authorizedAccountId) {
        this.authorizedAccountId = authorizedAccountId;
    }

    public String getAuthorizedAccountId() {
        return this.authorizedAccountId;
    }

    public PutAggregationAuthorizationRequest withAuthorizedAccountId(String authorizedAccountId) {
        this.setAuthorizedAccountId(authorizedAccountId);
        return this;
    }

    public void setAuthorizedAwsRegion(String authorizedAwsRegion) {
        this.authorizedAwsRegion = authorizedAwsRegion;
    }

    public String getAuthorizedAwsRegion() {
        return this.authorizedAwsRegion;
    }

    public PutAggregationAuthorizationRequest withAuthorizedAwsRegion(String authorizedAwsRegion) {
        this.setAuthorizedAwsRegion(authorizedAwsRegion);
        return this;
    }

    public List<Tag> getTags() {
        if (this.tags == null) {
            this.tags = new SdkInternalList();
        }
        return this.tags;
    }

    public void setTags(Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }
        this.tags = new SdkInternalList(tags);
    }

    public PutAggregationAuthorizationRequest withTags(Tag ... tags) {
        if (this.tags == null) {
            this.setTags((Collection<Tag>)new SdkInternalList(tags.length));
        }
        for (Tag ele : tags) {
            this.tags.add((Object)ele);
        }
        return this;
    }

    public PutAggregationAuthorizationRequest withTags(Collection<Tag> tags) {
        this.setTags(tags);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAuthorizedAccountId() != null) {
            sb.append("AuthorizedAccountId: ").append(this.getAuthorizedAccountId()).append(",");
        }
        if (this.getAuthorizedAwsRegion() != null) {
            sb.append("AuthorizedAwsRegion: ").append(this.getAuthorizedAwsRegion()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutAggregationAuthorizationRequest)) {
            return false;
        }
        PutAggregationAuthorizationRequest other = (PutAggregationAuthorizationRequest)obj;
        if (other.getAuthorizedAccountId() == null ^ this.getAuthorizedAccountId() == null) {
            return false;
        }
        if (other.getAuthorizedAccountId() != null && !other.getAuthorizedAccountId().equals(this.getAuthorizedAccountId())) {
            return false;
        }
        if (other.getAuthorizedAwsRegion() == null ^ this.getAuthorizedAwsRegion() == null) {
            return false;
        }
        if (other.getAuthorizedAwsRegion() != null && !other.getAuthorizedAwsRegion().equals(this.getAuthorizedAwsRegion())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        return other.getTags() == null || other.getTags().equals(this.getTags());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAuthorizedAccountId() == null ? 0 : this.getAuthorizedAccountId().hashCode());
        hashCode = 31 * hashCode + (this.getAuthorizedAwsRegion() == null ? 0 : this.getAuthorizedAwsRegion().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        return hashCode;
    }

    public PutAggregationAuthorizationRequest clone() {
        return (PutAggregationAuthorizationRequest)super.clone();
    }
}

