/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.config.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.config.model.ExecutionControls;
import com.amazonaws.services.config.model.RemediationParameterValue;
import com.amazonaws.services.config.model.RemediationTargetType;
import com.amazonaws.services.config.model.transform.RemediationConfigurationMarshaller;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class RemediationConfiguration
implements Serializable,
Cloneable,
StructuredPojo {
    private String configRuleName;
    private String targetType;
    private String targetId;
    private String targetVersion;
    private Map<String, RemediationParameterValue> parameters;
    private String resourceType;
    private Boolean automatic;
    private ExecutionControls executionControls;
    private Integer maximumAutomaticAttempts;
    private Long retryAttemptSeconds;
    private String arn;
    private String createdByService;

    public void setConfigRuleName(String configRuleName) {
        this.configRuleName = configRuleName;
    }

    public String getConfigRuleName() {
        return this.configRuleName;
    }

    public RemediationConfiguration withConfigRuleName(String configRuleName) {
        this.setConfigRuleName(configRuleName);
        return this;
    }

    public void setTargetType(String targetType) {
        this.targetType = targetType;
    }

    public String getTargetType() {
        return this.targetType;
    }

    public RemediationConfiguration withTargetType(String targetType) {
        this.setTargetType(targetType);
        return this;
    }

    public RemediationConfiguration withTargetType(RemediationTargetType targetType) {
        this.targetType = targetType.toString();
        return this;
    }

    public void setTargetId(String targetId) {
        this.targetId = targetId;
    }

    public String getTargetId() {
        return this.targetId;
    }

    public RemediationConfiguration withTargetId(String targetId) {
        this.setTargetId(targetId);
        return this;
    }

    public void setTargetVersion(String targetVersion) {
        this.targetVersion = targetVersion;
    }

    public String getTargetVersion() {
        return this.targetVersion;
    }

    public RemediationConfiguration withTargetVersion(String targetVersion) {
        this.setTargetVersion(targetVersion);
        return this;
    }

    public Map<String, RemediationParameterValue> getParameters() {
        return this.parameters;
    }

    public void setParameters(Map<String, RemediationParameterValue> parameters) {
        this.parameters = parameters;
    }

    public RemediationConfiguration withParameters(Map<String, RemediationParameterValue> parameters) {
        this.setParameters(parameters);
        return this;
    }

    public RemediationConfiguration addParametersEntry(String key, RemediationParameterValue value) {
        if (null == this.parameters) {
            this.parameters = new HashMap<String, RemediationParameterValue>();
        }
        if (this.parameters.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.parameters.put(key, value);
        return this;
    }

    public RemediationConfiguration clearParametersEntries() {
        this.parameters = null;
        return this;
    }

    public void setResourceType(String resourceType) {
        this.resourceType = resourceType;
    }

    public String getResourceType() {
        return this.resourceType;
    }

    public RemediationConfiguration withResourceType(String resourceType) {
        this.setResourceType(resourceType);
        return this;
    }

    public void setAutomatic(Boolean automatic) {
        this.automatic = automatic;
    }

    public Boolean getAutomatic() {
        return this.automatic;
    }

    public RemediationConfiguration withAutomatic(Boolean automatic) {
        this.setAutomatic(automatic);
        return this;
    }

    public Boolean isAutomatic() {
        return this.automatic;
    }

    public void setExecutionControls(ExecutionControls executionControls) {
        this.executionControls = executionControls;
    }

    public ExecutionControls getExecutionControls() {
        return this.executionControls;
    }

    public RemediationConfiguration withExecutionControls(ExecutionControls executionControls) {
        this.setExecutionControls(executionControls);
        return this;
    }

    public void setMaximumAutomaticAttempts(Integer maximumAutomaticAttempts) {
        this.maximumAutomaticAttempts = maximumAutomaticAttempts;
    }

    public Integer getMaximumAutomaticAttempts() {
        return this.maximumAutomaticAttempts;
    }

    public RemediationConfiguration withMaximumAutomaticAttempts(Integer maximumAutomaticAttempts) {
        this.setMaximumAutomaticAttempts(maximumAutomaticAttempts);
        return this;
    }

    public void setRetryAttemptSeconds(Long retryAttemptSeconds) {
        this.retryAttemptSeconds = retryAttemptSeconds;
    }

    public Long getRetryAttemptSeconds() {
        return this.retryAttemptSeconds;
    }

    public RemediationConfiguration withRetryAttemptSeconds(Long retryAttemptSeconds) {
        this.setRetryAttemptSeconds(retryAttemptSeconds);
        return this;
    }

    public void setArn(String arn) {
        this.arn = arn;
    }

    public String getArn() {
        return this.arn;
    }

    public RemediationConfiguration withArn(String arn) {
        this.setArn(arn);
        return this;
    }

    public void setCreatedByService(String createdByService) {
        this.createdByService = createdByService;
    }

    public String getCreatedByService() {
        return this.createdByService;
    }

    public RemediationConfiguration withCreatedByService(String createdByService) {
        this.setCreatedByService(createdByService);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getConfigRuleName() != null) {
            sb.append("ConfigRuleName: ").append(this.getConfigRuleName()).append(",");
        }
        if (this.getTargetType() != null) {
            sb.append("TargetType: ").append(this.getTargetType()).append(",");
        }
        if (this.getTargetId() != null) {
            sb.append("TargetId: ").append(this.getTargetId()).append(",");
        }
        if (this.getTargetVersion() != null) {
            sb.append("TargetVersion: ").append(this.getTargetVersion()).append(",");
        }
        if (this.getParameters() != null) {
            sb.append("Parameters: ").append(this.getParameters()).append(",");
        }
        if (this.getResourceType() != null) {
            sb.append("ResourceType: ").append(this.getResourceType()).append(",");
        }
        if (this.getAutomatic() != null) {
            sb.append("Automatic: ").append(this.getAutomatic()).append(",");
        }
        if (this.getExecutionControls() != null) {
            sb.append("ExecutionControls: ").append(this.getExecutionControls()).append(",");
        }
        if (this.getMaximumAutomaticAttempts() != null) {
            sb.append("MaximumAutomaticAttempts: ").append(this.getMaximumAutomaticAttempts()).append(",");
        }
        if (this.getRetryAttemptSeconds() != null) {
            sb.append("RetryAttemptSeconds: ").append(this.getRetryAttemptSeconds()).append(",");
        }
        if (this.getArn() != null) {
            sb.append("Arn: ").append(this.getArn()).append(",");
        }
        if (this.getCreatedByService() != null) {
            sb.append("CreatedByService: ").append(this.getCreatedByService());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RemediationConfiguration)) {
            return false;
        }
        RemediationConfiguration other = (RemediationConfiguration)obj;
        if (other.getConfigRuleName() == null ^ this.getConfigRuleName() == null) {
            return false;
        }
        if (other.getConfigRuleName() != null && !other.getConfigRuleName().equals(this.getConfigRuleName())) {
            return false;
        }
        if (other.getTargetType() == null ^ this.getTargetType() == null) {
            return false;
        }
        if (other.getTargetType() != null && !other.getTargetType().equals(this.getTargetType())) {
            return false;
        }
        if (other.getTargetId() == null ^ this.getTargetId() == null) {
            return false;
        }
        if (other.getTargetId() != null && !other.getTargetId().equals(this.getTargetId())) {
            return false;
        }
        if (other.getTargetVersion() == null ^ this.getTargetVersion() == null) {
            return false;
        }
        if (other.getTargetVersion() != null && !other.getTargetVersion().equals(this.getTargetVersion())) {
            return false;
        }
        if (other.getParameters() == null ^ this.getParameters() == null) {
            return false;
        }
        if (other.getParameters() != null && !other.getParameters().equals(this.getParameters())) {
            return false;
        }
        if (other.getResourceType() == null ^ this.getResourceType() == null) {
            return false;
        }
        if (other.getResourceType() != null && !other.getResourceType().equals(this.getResourceType())) {
            return false;
        }
        if (other.getAutomatic() == null ^ this.getAutomatic() == null) {
            return false;
        }
        if (other.getAutomatic() != null && !other.getAutomatic().equals(this.getAutomatic())) {
            return false;
        }
        if (other.getExecutionControls() == null ^ this.getExecutionControls() == null) {
            return false;
        }
        if (other.getExecutionControls() != null && !other.getExecutionControls().equals(this.getExecutionControls())) {
            return false;
        }
        if (other.getMaximumAutomaticAttempts() == null ^ this.getMaximumAutomaticAttempts() == null) {
            return false;
        }
        if (other.getMaximumAutomaticAttempts() != null && !other.getMaximumAutomaticAttempts().equals(this.getMaximumAutomaticAttempts())) {
            return false;
        }
        if (other.getRetryAttemptSeconds() == null ^ this.getRetryAttemptSeconds() == null) {
            return false;
        }
        if (other.getRetryAttemptSeconds() != null && !other.getRetryAttemptSeconds().equals(this.getRetryAttemptSeconds())) {
            return false;
        }
        if (other.getArn() == null ^ this.getArn() == null) {
            return false;
        }
        if (other.getArn() != null && !other.getArn().equals(this.getArn())) {
            return false;
        }
        if (other.getCreatedByService() == null ^ this.getCreatedByService() == null) {
            return false;
        }
        return other.getCreatedByService() == null || other.getCreatedByService().equals(this.getCreatedByService());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getConfigRuleName() == null ? 0 : this.getConfigRuleName().hashCode());
        hashCode = 31 * hashCode + (this.getTargetType() == null ? 0 : this.getTargetType().hashCode());
        hashCode = 31 * hashCode + (this.getTargetId() == null ? 0 : this.getTargetId().hashCode());
        hashCode = 31 * hashCode + (this.getTargetVersion() == null ? 0 : this.getTargetVersion().hashCode());
        hashCode = 31 * hashCode + (this.getParameters() == null ? 0 : this.getParameters().hashCode());
        hashCode = 31 * hashCode + (this.getResourceType() == null ? 0 : this.getResourceType().hashCode());
        hashCode = 31 * hashCode + (this.getAutomatic() == null ? 0 : this.getAutomatic().hashCode());
        hashCode = 31 * hashCode + (this.getExecutionControls() == null ? 0 : this.getExecutionControls().hashCode());
        hashCode = 31 * hashCode + (this.getMaximumAutomaticAttempts() == null ? 0 : this.getMaximumAutomaticAttempts().hashCode());
        hashCode = 31 * hashCode + (this.getRetryAttemptSeconds() == null ? 0 : this.getRetryAttemptSeconds().hashCode());
        hashCode = 31 * hashCode + (this.getArn() == null ? 0 : this.getArn().hashCode());
        hashCode = 31 * hashCode + (this.getCreatedByService() == null ? 0 : this.getCreatedByService().hashCode());
        return hashCode;
    }

    public RemediationConfiguration clone() {
        try {
            return (RemediationConfiguration)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        RemediationConfigurationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

