/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.config.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.protocol.json.SdkJsonMarshallerFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.config.model.DescribeConfigRuleEvaluationStatusRequest;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class DescribeConfigRuleEvaluationStatusRequestMarshaller
implements Marshaller<Request<DescribeConfigRuleEvaluationStatusRequest>, DescribeConfigRuleEvaluationStatusRequest> {
    private final SdkJsonMarshallerFactory protocolFactory;

    public DescribeConfigRuleEvaluationStatusRequestMarshaller(SdkJsonMarshallerFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<DescribeConfigRuleEvaluationStatusRequest> marshall(DescribeConfigRuleEvaluationStatusRequest describeConfigRuleEvaluationStatusRequest) {
        if (describeConfigRuleEvaluationStatusRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeConfigRuleEvaluationStatusRequest, "AmazonConfig");
        request.addHeader("X-Amz-Target", "StarlingDoveService.DescribeConfigRuleEvaluationStatus");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            SdkInternalList configRuleNamesList = (SdkInternalList)describeConfigRuleEvaluationStatusRequest.getConfigRuleNames();
            if (!configRuleNamesList.isEmpty() || !configRuleNamesList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("ConfigRuleNames");
                jsonGenerator.writeStartArray();
                for (String configRuleNamesListValue : configRuleNamesList) {
                    if (configRuleNamesListValue == null) continue;
                    jsonGenerator.writeValue(configRuleNamesListValue);
                }
                jsonGenerator.writeEndArray();
            }
            if (describeConfigRuleEvaluationStatusRequest.getNextToken() != null) {
                jsonGenerator.writeFieldName("NextToken").writeValue(describeConfigRuleEvaluationStatusRequest.getNextToken());
            }
            if (describeConfigRuleEvaluationStatusRequest.getLimit() != null) {
                jsonGenerator.writeFieldName("Limit").writeValue(describeConfigRuleEvaluationStatusRequest.getLimit().intValue());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

