/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.config.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.protocol.json.SdkJsonMarshallerFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.config.model.DescribeConfigurationRecorderStatusRequest;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class DescribeConfigurationRecorderStatusRequestMarshaller
implements Marshaller<Request<DescribeConfigurationRecorderStatusRequest>, DescribeConfigurationRecorderStatusRequest> {
    private final SdkJsonMarshallerFactory protocolFactory;

    public DescribeConfigurationRecorderStatusRequestMarshaller(SdkJsonMarshallerFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<DescribeConfigurationRecorderStatusRequest> marshall(DescribeConfigurationRecorderStatusRequest describeConfigurationRecorderStatusRequest) {
        if (describeConfigurationRecorderStatusRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeConfigurationRecorderStatusRequest, "AmazonConfig");
        request.addHeader("X-Amz-Target", "StarlingDoveService.DescribeConfigurationRecorderStatus");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            SdkInternalList configurationRecorderNamesList = (SdkInternalList)describeConfigurationRecorderStatusRequest.getConfigurationRecorderNames();
            if (!configurationRecorderNamesList.isEmpty() || !configurationRecorderNamesList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("ConfigurationRecorderNames");
                jsonGenerator.writeStartArray();
                for (String configurationRecorderNamesListValue : configurationRecorderNamesList) {
                    if (configurationRecorderNamesListValue == null) continue;
                    jsonGenerator.writeValue(configurationRecorderNamesListValue);
                }
                jsonGenerator.writeEndArray();
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

