/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.config.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.config.model.DescribeConfigurationRecordersRequest;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class DescribeConfigurationRecordersRequestMarshaller
implements Marshaller<Request<DescribeConfigurationRecordersRequest>, DescribeConfigurationRecordersRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public DescribeConfigurationRecordersRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<DescribeConfigurationRecordersRequest> marshall(DescribeConfigurationRecordersRequest describeConfigurationRecordersRequest) {
        if (describeConfigurationRecordersRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeConfigurationRecordersRequest, "AmazonConfig");
        request.addHeader("X-Amz-Target", "StarlingDoveService.DescribeConfigurationRecorders");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            SdkInternalList configurationRecorderNamesList = (SdkInternalList)describeConfigurationRecordersRequest.getConfigurationRecorderNames();
            if (!configurationRecorderNamesList.isEmpty() || !configurationRecorderNamesList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("ConfigurationRecorderNames");
                jsonGenerator.writeStartArray();
                for (String configurationRecorderNamesListValue : configurationRecorderNamesList) {
                    if (configurationRecorderNamesListValue == null) continue;
                    jsonGenerator.writeValue(configurationRecorderNamesListValue);
                }
                jsonGenerator.writeEndArray();
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

