/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.config.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.config.model.GetComplianceDetailsByConfigRuleRequest;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class GetComplianceDetailsByConfigRuleRequestMarshaller
implements Marshaller<Request<GetComplianceDetailsByConfigRuleRequest>, GetComplianceDetailsByConfigRuleRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public GetComplianceDetailsByConfigRuleRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<GetComplianceDetailsByConfigRuleRequest> marshall(GetComplianceDetailsByConfigRuleRequest getComplianceDetailsByConfigRuleRequest) {
        if (getComplianceDetailsByConfigRuleRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)getComplianceDetailsByConfigRuleRequest, "AmazonConfig");
        request.addHeader("X-Amz-Target", "StarlingDoveService.GetComplianceDetailsByConfigRule");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            SdkInternalList complianceTypesList;
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (getComplianceDetailsByConfigRuleRequest.getConfigRuleName() != null) {
                jsonGenerator.writeFieldName("ConfigRuleName").writeValue(getComplianceDetailsByConfigRuleRequest.getConfigRuleName());
            }
            if (!(complianceTypesList = (SdkInternalList)getComplianceDetailsByConfigRuleRequest.getComplianceTypes()).isEmpty() || !complianceTypesList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("ComplianceTypes");
                jsonGenerator.writeStartArray();
                for (String complianceTypesListValue : complianceTypesList) {
                    if (complianceTypesListValue == null) continue;
                    jsonGenerator.writeValue(complianceTypesListValue);
                }
                jsonGenerator.writeEndArray();
            }
            if (getComplianceDetailsByConfigRuleRequest.getLimit() != null) {
                jsonGenerator.writeFieldName("Limit").writeValue(getComplianceDetailsByConfigRuleRequest.getLimit().intValue());
            }
            if (getComplianceDetailsByConfigRuleRequest.getNextToken() != null) {
                jsonGenerator.writeFieldName("NextToken").writeValue(getComplianceDetailsByConfigRuleRequest.getNextToken());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

