/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.config.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.config.model.RemediationParameterValue;
import com.amazonaws.services.config.model.RemediationTargetType;
import com.amazonaws.services.config.model.transform.RemediationConfigurationMarshaller;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class RemediationConfiguration
implements Serializable,
Cloneable,
StructuredPojo {
    private String configRuleName;
    private String targetType;
    private String targetId;
    private String targetVersion;
    private Map<String, RemediationParameterValue> parameters;
    private String resourceType;

    public void setConfigRuleName(String configRuleName) {
        this.configRuleName = configRuleName;
    }

    public String getConfigRuleName() {
        return this.configRuleName;
    }

    public RemediationConfiguration withConfigRuleName(String configRuleName) {
        this.setConfigRuleName(configRuleName);
        return this;
    }

    public void setTargetType(String targetType) {
        this.targetType = targetType;
    }

    public String getTargetType() {
        return this.targetType;
    }

    public RemediationConfiguration withTargetType(String targetType) {
        this.setTargetType(targetType);
        return this;
    }

    public RemediationConfiguration withTargetType(RemediationTargetType targetType) {
        this.targetType = targetType.toString();
        return this;
    }

    public void setTargetId(String targetId) {
        this.targetId = targetId;
    }

    public String getTargetId() {
        return this.targetId;
    }

    public RemediationConfiguration withTargetId(String targetId) {
        this.setTargetId(targetId);
        return this;
    }

    public void setTargetVersion(String targetVersion) {
        this.targetVersion = targetVersion;
    }

    public String getTargetVersion() {
        return this.targetVersion;
    }

    public RemediationConfiguration withTargetVersion(String targetVersion) {
        this.setTargetVersion(targetVersion);
        return this;
    }

    public Map<String, RemediationParameterValue> getParameters() {
        return this.parameters;
    }

    public void setParameters(Map<String, RemediationParameterValue> parameters) {
        this.parameters = parameters;
    }

    public RemediationConfiguration withParameters(Map<String, RemediationParameterValue> parameters) {
        this.setParameters(parameters);
        return this;
    }

    public RemediationConfiguration addParametersEntry(String key, RemediationParameterValue value) {
        if (null == this.parameters) {
            this.parameters = new HashMap<String, RemediationParameterValue>();
        }
        if (this.parameters.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.parameters.put(key, value);
        return this;
    }

    public RemediationConfiguration clearParametersEntries() {
        this.parameters = null;
        return this;
    }

    public void setResourceType(String resourceType) {
        this.resourceType = resourceType;
    }

    public String getResourceType() {
        return this.resourceType;
    }

    public RemediationConfiguration withResourceType(String resourceType) {
        this.setResourceType(resourceType);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getConfigRuleName() != null) {
            sb.append("ConfigRuleName: ").append(this.getConfigRuleName()).append(",");
        }
        if (this.getTargetType() != null) {
            sb.append("TargetType: ").append(this.getTargetType()).append(",");
        }
        if (this.getTargetId() != null) {
            sb.append("TargetId: ").append(this.getTargetId()).append(",");
        }
        if (this.getTargetVersion() != null) {
            sb.append("TargetVersion: ").append(this.getTargetVersion()).append(",");
        }
        if (this.getParameters() != null) {
            sb.append("Parameters: ").append(this.getParameters()).append(",");
        }
        if (this.getResourceType() != null) {
            sb.append("ResourceType: ").append(this.getResourceType());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RemediationConfiguration)) {
            return false;
        }
        RemediationConfiguration other = (RemediationConfiguration)obj;
        if (other.getConfigRuleName() == null ^ this.getConfigRuleName() == null) {
            return false;
        }
        if (other.getConfigRuleName() != null && !other.getConfigRuleName().equals(this.getConfigRuleName())) {
            return false;
        }
        if (other.getTargetType() == null ^ this.getTargetType() == null) {
            return false;
        }
        if (other.getTargetType() != null && !other.getTargetType().equals(this.getTargetType())) {
            return false;
        }
        if (other.getTargetId() == null ^ this.getTargetId() == null) {
            return false;
        }
        if (other.getTargetId() != null && !other.getTargetId().equals(this.getTargetId())) {
            return false;
        }
        if (other.getTargetVersion() == null ^ this.getTargetVersion() == null) {
            return false;
        }
        if (other.getTargetVersion() != null && !other.getTargetVersion().equals(this.getTargetVersion())) {
            return false;
        }
        if (other.getParameters() == null ^ this.getParameters() == null) {
            return false;
        }
        if (other.getParameters() != null && !other.getParameters().equals(this.getParameters())) {
            return false;
        }
        if (other.getResourceType() == null ^ this.getResourceType() == null) {
            return false;
        }
        return other.getResourceType() == null || other.getResourceType().equals(this.getResourceType());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getConfigRuleName() == null ? 0 : this.getConfigRuleName().hashCode());
        hashCode = 31 * hashCode + (this.getTargetType() == null ? 0 : this.getTargetType().hashCode());
        hashCode = 31 * hashCode + (this.getTargetId() == null ? 0 : this.getTargetId().hashCode());
        hashCode = 31 * hashCode + (this.getTargetVersion() == null ? 0 : this.getTargetVersion().hashCode());
        hashCode = 31 * hashCode + (this.getParameters() == null ? 0 : this.getParameters().hashCode());
        hashCode = 31 * hashCode + (this.getResourceType() == null ? 0 : this.getResourceType().hashCode());
        return hashCode;
    }

    public RemediationConfiguration clone() {
        try {
            return (RemediationConfiguration)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        RemediationConfigurationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

