/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.config.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.config.model.DeliverConfigSnapshotRequest;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class DeliverConfigSnapshotRequestMarshaller
implements Marshaller<Request<DeliverConfigSnapshotRequest>, DeliverConfigSnapshotRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public DeliverConfigSnapshotRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<DeliverConfigSnapshotRequest> marshall(DeliverConfigSnapshotRequest deliverConfigSnapshotRequest) {
        if (deliverConfigSnapshotRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)deliverConfigSnapshotRequest, "AmazonConfig");
        request.addHeader("X-Amz-Target", "StarlingDoveService.DeliverConfigSnapshot");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (deliverConfigSnapshotRequest.getDeliveryChannelName() != null) {
                jsonGenerator.writeFieldName("deliveryChannelName").writeValue(deliverConfigSnapshotRequest.getDeliveryChannelName());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

