/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.config.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.config.model.Source;
import com.amazonaws.services.config.model.SourceDetail;
import com.amazonaws.services.config.model.transform.SourceDetailJsonMarshaller;

public class SourceJsonMarshaller {
    private static SourceJsonMarshaller instance;

    public void marshall(Source source, StructuredJsonGenerator jsonGenerator) {
        if (source == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            SdkInternalList sourceDetailsList;
            jsonGenerator.writeStartObject();
            if (source.getOwner() != null) {
                jsonGenerator.writeFieldName("Owner").writeValue(source.getOwner());
            }
            if (source.getSourceIdentifier() != null) {
                jsonGenerator.writeFieldName("SourceIdentifier").writeValue(source.getSourceIdentifier());
            }
            if (!(sourceDetailsList = (SdkInternalList)source.getSourceDetails()).isEmpty() || !sourceDetailsList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("SourceDetails");
                jsonGenerator.writeStartArray();
                for (SourceDetail sourceDetailsListValue : sourceDetailsList) {
                    if (sourceDetailsListValue == null) continue;
                    SourceDetailJsonMarshaller.getInstance().marshall(sourceDetailsListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static SourceJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new SourceJsonMarshaller();
        }
        return instance;
    }
}

