/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.config.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.config.model.Evaluation;
import com.amazonaws.services.config.model.PutEvaluationsRequest;
import com.amazonaws.services.config.model.transform.EvaluationJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.json.SdkJsonGenerator;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class PutEvaluationsRequestMarshaller
implements Marshaller<Request<PutEvaluationsRequest>, PutEvaluationsRequest> {
    public Request<PutEvaluationsRequest> marshall(PutEvaluationsRequest putEvaluationsRequest) {
        if (putEvaluationsRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)putEvaluationsRequest, "AmazonConfig");
        request.addHeader("X-Amz-Target", "StarlingDoveService.PutEvaluations");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            SdkJsonGenerator jsonGenerator = new SdkJsonGenerator();
            jsonGenerator.writeStartObject();
            SdkInternalList evaluationsList = (SdkInternalList)putEvaluationsRequest.getEvaluations();
            if (!evaluationsList.isEmpty() || !evaluationsList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("Evaluations");
                jsonGenerator.writeStartArray();
                for (Evaluation evaluationsListValue : evaluationsList) {
                    if (evaluationsListValue == null) continue;
                    EvaluationJsonMarshaller.getInstance().marshall(evaluationsListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            if (putEvaluationsRequest.getResultToken() != null) {
                jsonGenerator.writeFieldName("ResultToken").writeValue(putEvaluationsRequest.getResultToken());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

