/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.config.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.config.model.ResourceType;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ListDiscoveredResourcesRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String resourceType;
    private ListWithAutoConstructFlag<String> resourceIds;
    private String resourceName;
    private Integer limit;
    private Boolean includeDeletedResources;
    private String nextToken;

    public String getResourceType() {
        return this.resourceType;
    }

    public void setResourceType(String resourceType) {
        this.resourceType = resourceType;
    }

    public ListDiscoveredResourcesRequest withResourceType(String resourceType) {
        this.resourceType = resourceType;
        return this;
    }

    public void setResourceType(ResourceType resourceType) {
        this.resourceType = resourceType.toString();
    }

    public ListDiscoveredResourcesRequest withResourceType(ResourceType resourceType) {
        this.resourceType = resourceType.toString();
        return this;
    }

    public List<String> getResourceIds() {
        if (this.resourceIds == null) {
            this.resourceIds = new ListWithAutoConstructFlag();
            this.resourceIds.setAutoConstruct(true);
        }
        return this.resourceIds;
    }

    public void setResourceIds(Collection<String> resourceIds) {
        if (resourceIds == null) {
            this.resourceIds = null;
            return;
        }
        ListWithAutoConstructFlag resourceIdsCopy = new ListWithAutoConstructFlag(resourceIds.size());
        resourceIdsCopy.addAll(resourceIds);
        this.resourceIds = resourceIdsCopy;
    }

    public ListDiscoveredResourcesRequest withResourceIds(String ... resourceIds) {
        if (this.getResourceIds() == null) {
            this.setResourceIds(new ArrayList<String>(resourceIds.length));
        }
        for (String value : resourceIds) {
            this.getResourceIds().add(value);
        }
        return this;
    }

    public ListDiscoveredResourcesRequest withResourceIds(Collection<String> resourceIds) {
        if (resourceIds == null) {
            this.resourceIds = null;
        } else {
            ListWithAutoConstructFlag resourceIdsCopy = new ListWithAutoConstructFlag(resourceIds.size());
            resourceIdsCopy.addAll(resourceIds);
            this.resourceIds = resourceIdsCopy;
        }
        return this;
    }

    public String getResourceName() {
        return this.resourceName;
    }

    public void setResourceName(String resourceName) {
        this.resourceName = resourceName;
    }

    public ListDiscoveredResourcesRequest withResourceName(String resourceName) {
        this.resourceName = resourceName;
        return this;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public void setLimit(Integer limit) {
        this.limit = limit;
    }

    public ListDiscoveredResourcesRequest withLimit(Integer limit) {
        this.limit = limit;
        return this;
    }

    public Boolean isIncludeDeletedResources() {
        return this.includeDeletedResources;
    }

    public void setIncludeDeletedResources(Boolean includeDeletedResources) {
        this.includeDeletedResources = includeDeletedResources;
    }

    public ListDiscoveredResourcesRequest withIncludeDeletedResources(Boolean includeDeletedResources) {
        this.includeDeletedResources = includeDeletedResources;
        return this;
    }

    public Boolean getIncludeDeletedResources() {
        return this.includeDeletedResources;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public ListDiscoveredResourcesRequest withNextToken(String nextToken) {
        this.nextToken = nextToken;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getResourceType() != null) {
            sb.append("ResourceType: " + this.getResourceType() + ",");
        }
        if (this.getResourceIds() != null) {
            sb.append("ResourceIds: " + this.getResourceIds() + ",");
        }
        if (this.getResourceName() != null) {
            sb.append("ResourceName: " + this.getResourceName() + ",");
        }
        if (this.getLimit() != null) {
            sb.append("Limit: " + this.getLimit() + ",");
        }
        if (this.isIncludeDeletedResources() != null) {
            sb.append("IncludeDeletedResources: " + this.isIncludeDeletedResources() + ",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: " + this.getNextToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getResourceType() == null ? 0 : this.getResourceType().hashCode());
        hashCode = 31 * hashCode + (this.getResourceIds() == null ? 0 : this.getResourceIds().hashCode());
        hashCode = 31 * hashCode + (this.getResourceName() == null ? 0 : this.getResourceName().hashCode());
        hashCode = 31 * hashCode + (this.getLimit() == null ? 0 : this.getLimit().hashCode());
        hashCode = 31 * hashCode + (this.isIncludeDeletedResources() == null ? 0 : this.isIncludeDeletedResources().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDiscoveredResourcesRequest)) {
            return false;
        }
        ListDiscoveredResourcesRequest other = (ListDiscoveredResourcesRequest)obj;
        if (other.getResourceType() == null ^ this.getResourceType() == null) {
            return false;
        }
        if (other.getResourceType() != null && !other.getResourceType().equals(this.getResourceType())) {
            return false;
        }
        if (other.getResourceIds() == null ^ this.getResourceIds() == null) {
            return false;
        }
        if (other.getResourceIds() != null && !other.getResourceIds().equals(this.getResourceIds())) {
            return false;
        }
        if (other.getResourceName() == null ^ this.getResourceName() == null) {
            return false;
        }
        if (other.getResourceName() != null && !other.getResourceName().equals(this.getResourceName())) {
            return false;
        }
        if (other.getLimit() == null ^ this.getLimit() == null) {
            return false;
        }
        if (other.getLimit() != null && !other.getLimit().equals(this.getLimit())) {
            return false;
        }
        if (other.isIncludeDeletedResources() == null ^ this.isIncludeDeletedResources() == null) {
            return false;
        }
        if (other.isIncludeDeletedResources() != null && !other.isIncludeDeletedResources().equals(this.isIncludeDeletedResources())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        return other.getNextToken() == null || other.getNextToken().equals(this.getNextToken());
    }

    public ListDiscoveredResourcesRequest clone() {
        return (ListDiscoveredResourcesRequest)super.clone();
    }
}

