/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.computeoptimizer.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.computeoptimizer.model.AutoScalingGroupConfiguration;
import com.amazonaws.services.computeoptimizer.model.AutoScalingGroupSavingsOpportunityAfterDiscounts;
import com.amazonaws.services.computeoptimizer.model.GpuInfo;
import com.amazonaws.services.computeoptimizer.model.MigrationEffort;
import com.amazonaws.services.computeoptimizer.model.SavingsOpportunity;
import com.amazonaws.services.computeoptimizer.model.UtilizationMetric;
import com.amazonaws.services.computeoptimizer.model.transform.AutoScalingGroupRecommendationOptionMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class AutoScalingGroupRecommendationOption
implements Serializable,
Cloneable,
StructuredPojo {
    private AutoScalingGroupConfiguration configuration;
    private GpuInfo instanceGpuInfo;
    private List<UtilizationMetric> projectedUtilizationMetrics;
    private Double performanceRisk;
    private Integer rank;
    private SavingsOpportunity savingsOpportunity;
    private AutoScalingGroupSavingsOpportunityAfterDiscounts savingsOpportunityAfterDiscounts;
    private String migrationEffort;

    public void setConfiguration(AutoScalingGroupConfiguration configuration) {
        this.configuration = configuration;
    }

    public AutoScalingGroupConfiguration getConfiguration() {
        return this.configuration;
    }

    public AutoScalingGroupRecommendationOption withConfiguration(AutoScalingGroupConfiguration configuration) {
        this.setConfiguration(configuration);
        return this;
    }

    public void setInstanceGpuInfo(GpuInfo instanceGpuInfo) {
        this.instanceGpuInfo = instanceGpuInfo;
    }

    public GpuInfo getInstanceGpuInfo() {
        return this.instanceGpuInfo;
    }

    public AutoScalingGroupRecommendationOption withInstanceGpuInfo(GpuInfo instanceGpuInfo) {
        this.setInstanceGpuInfo(instanceGpuInfo);
        return this;
    }

    public List<UtilizationMetric> getProjectedUtilizationMetrics() {
        return this.projectedUtilizationMetrics;
    }

    public void setProjectedUtilizationMetrics(Collection<UtilizationMetric> projectedUtilizationMetrics) {
        if (projectedUtilizationMetrics == null) {
            this.projectedUtilizationMetrics = null;
            return;
        }
        this.projectedUtilizationMetrics = new ArrayList<UtilizationMetric>(projectedUtilizationMetrics);
    }

    public AutoScalingGroupRecommendationOption withProjectedUtilizationMetrics(UtilizationMetric ... projectedUtilizationMetrics) {
        if (this.projectedUtilizationMetrics == null) {
            this.setProjectedUtilizationMetrics(new ArrayList<UtilizationMetric>(projectedUtilizationMetrics.length));
        }
        for (UtilizationMetric ele : projectedUtilizationMetrics) {
            this.projectedUtilizationMetrics.add(ele);
        }
        return this;
    }

    public AutoScalingGroupRecommendationOption withProjectedUtilizationMetrics(Collection<UtilizationMetric> projectedUtilizationMetrics) {
        this.setProjectedUtilizationMetrics(projectedUtilizationMetrics);
        return this;
    }

    public void setPerformanceRisk(Double performanceRisk) {
        this.performanceRisk = performanceRisk;
    }

    public Double getPerformanceRisk() {
        return this.performanceRisk;
    }

    public AutoScalingGroupRecommendationOption withPerformanceRisk(Double performanceRisk) {
        this.setPerformanceRisk(performanceRisk);
        return this;
    }

    public void setRank(Integer rank) {
        this.rank = rank;
    }

    public Integer getRank() {
        return this.rank;
    }

    public AutoScalingGroupRecommendationOption withRank(Integer rank) {
        this.setRank(rank);
        return this;
    }

    public void setSavingsOpportunity(SavingsOpportunity savingsOpportunity) {
        this.savingsOpportunity = savingsOpportunity;
    }

    public SavingsOpportunity getSavingsOpportunity() {
        return this.savingsOpportunity;
    }

    public AutoScalingGroupRecommendationOption withSavingsOpportunity(SavingsOpportunity savingsOpportunity) {
        this.setSavingsOpportunity(savingsOpportunity);
        return this;
    }

    public void setSavingsOpportunityAfterDiscounts(AutoScalingGroupSavingsOpportunityAfterDiscounts savingsOpportunityAfterDiscounts) {
        this.savingsOpportunityAfterDiscounts = savingsOpportunityAfterDiscounts;
    }

    public AutoScalingGroupSavingsOpportunityAfterDiscounts getSavingsOpportunityAfterDiscounts() {
        return this.savingsOpportunityAfterDiscounts;
    }

    public AutoScalingGroupRecommendationOption withSavingsOpportunityAfterDiscounts(AutoScalingGroupSavingsOpportunityAfterDiscounts savingsOpportunityAfterDiscounts) {
        this.setSavingsOpportunityAfterDiscounts(savingsOpportunityAfterDiscounts);
        return this;
    }

    public void setMigrationEffort(String migrationEffort) {
        this.migrationEffort = migrationEffort;
    }

    public String getMigrationEffort() {
        return this.migrationEffort;
    }

    public AutoScalingGroupRecommendationOption withMigrationEffort(String migrationEffort) {
        this.setMigrationEffort(migrationEffort);
        return this;
    }

    public AutoScalingGroupRecommendationOption withMigrationEffort(MigrationEffort migrationEffort) {
        this.migrationEffort = migrationEffort.toString();
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getConfiguration() != null) {
            sb.append("Configuration: ").append(this.getConfiguration()).append(",");
        }
        if (this.getInstanceGpuInfo() != null) {
            sb.append("InstanceGpuInfo: ").append(this.getInstanceGpuInfo()).append(",");
        }
        if (this.getProjectedUtilizationMetrics() != null) {
            sb.append("ProjectedUtilizationMetrics: ").append(this.getProjectedUtilizationMetrics()).append(",");
        }
        if (this.getPerformanceRisk() != null) {
            sb.append("PerformanceRisk: ").append(this.getPerformanceRisk()).append(",");
        }
        if (this.getRank() != null) {
            sb.append("Rank: ").append(this.getRank()).append(",");
        }
        if (this.getSavingsOpportunity() != null) {
            sb.append("SavingsOpportunity: ").append(this.getSavingsOpportunity()).append(",");
        }
        if (this.getSavingsOpportunityAfterDiscounts() != null) {
            sb.append("SavingsOpportunityAfterDiscounts: ").append(this.getSavingsOpportunityAfterDiscounts()).append(",");
        }
        if (this.getMigrationEffort() != null) {
            sb.append("MigrationEffort: ").append(this.getMigrationEffort());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AutoScalingGroupRecommendationOption)) {
            return false;
        }
        AutoScalingGroupRecommendationOption other = (AutoScalingGroupRecommendationOption)obj;
        if (other.getConfiguration() == null ^ this.getConfiguration() == null) {
            return false;
        }
        if (other.getConfiguration() != null && !other.getConfiguration().equals(this.getConfiguration())) {
            return false;
        }
        if (other.getInstanceGpuInfo() == null ^ this.getInstanceGpuInfo() == null) {
            return false;
        }
        if (other.getInstanceGpuInfo() != null && !other.getInstanceGpuInfo().equals(this.getInstanceGpuInfo())) {
            return false;
        }
        if (other.getProjectedUtilizationMetrics() == null ^ this.getProjectedUtilizationMetrics() == null) {
            return false;
        }
        if (other.getProjectedUtilizationMetrics() != null && !other.getProjectedUtilizationMetrics().equals(this.getProjectedUtilizationMetrics())) {
            return false;
        }
        if (other.getPerformanceRisk() == null ^ this.getPerformanceRisk() == null) {
            return false;
        }
        if (other.getPerformanceRisk() != null && !other.getPerformanceRisk().equals(this.getPerformanceRisk())) {
            return false;
        }
        if (other.getRank() == null ^ this.getRank() == null) {
            return false;
        }
        if (other.getRank() != null && !other.getRank().equals(this.getRank())) {
            return false;
        }
        if (other.getSavingsOpportunity() == null ^ this.getSavingsOpportunity() == null) {
            return false;
        }
        if (other.getSavingsOpportunity() != null && !other.getSavingsOpportunity().equals(this.getSavingsOpportunity())) {
            return false;
        }
        if (other.getSavingsOpportunityAfterDiscounts() == null ^ this.getSavingsOpportunityAfterDiscounts() == null) {
            return false;
        }
        if (other.getSavingsOpportunityAfterDiscounts() != null && !other.getSavingsOpportunityAfterDiscounts().equals(this.getSavingsOpportunityAfterDiscounts())) {
            return false;
        }
        if (other.getMigrationEffort() == null ^ this.getMigrationEffort() == null) {
            return false;
        }
        return other.getMigrationEffort() == null || other.getMigrationEffort().equals(this.getMigrationEffort());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getConfiguration() == null ? 0 : this.getConfiguration().hashCode());
        hashCode = 31 * hashCode + (this.getInstanceGpuInfo() == null ? 0 : this.getInstanceGpuInfo().hashCode());
        hashCode = 31 * hashCode + (this.getProjectedUtilizationMetrics() == null ? 0 : this.getProjectedUtilizationMetrics().hashCode());
        hashCode = 31 * hashCode + (this.getPerformanceRisk() == null ? 0 : this.getPerformanceRisk().hashCode());
        hashCode = 31 * hashCode + (this.getRank() == null ? 0 : this.getRank().hashCode());
        hashCode = 31 * hashCode + (this.getSavingsOpportunity() == null ? 0 : this.getSavingsOpportunity().hashCode());
        hashCode = 31 * hashCode + (this.getSavingsOpportunityAfterDiscounts() == null ? 0 : this.getSavingsOpportunityAfterDiscounts().hashCode());
        hashCode = 31 * hashCode + (this.getMigrationEffort() == null ? 0 : this.getMigrationEffort().hashCode());
        return hashCode;
    }

    public AutoScalingGroupRecommendationOption clone() {
        try {
            return (AutoScalingGroupRecommendationOption)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        AutoScalingGroupRecommendationOptionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

