/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.computeoptimizer.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.computeoptimizer.model.CurrentPerformanceRisk;
import com.amazonaws.services.computeoptimizer.model.ECSEffectiveRecommendationPreferences;
import com.amazonaws.services.computeoptimizer.model.ECSServiceLaunchType;
import com.amazonaws.services.computeoptimizer.model.ECSServiceRecommendationFinding;
import com.amazonaws.services.computeoptimizer.model.ECSServiceRecommendationFindingReasonCode;
import com.amazonaws.services.computeoptimizer.model.ECSServiceRecommendationOption;
import com.amazonaws.services.computeoptimizer.model.ECSServiceUtilizationMetric;
import com.amazonaws.services.computeoptimizer.model.ServiceConfiguration;
import com.amazonaws.services.computeoptimizer.model.Tag;
import com.amazonaws.services.computeoptimizer.model.transform.ECSServiceRecommendationMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class ECSServiceRecommendation
implements Serializable,
Cloneable,
StructuredPojo {
    private String serviceArn;
    private String accountId;
    private ServiceConfiguration currentServiceConfiguration;
    private List<ECSServiceUtilizationMetric> utilizationMetrics;
    private Double lookbackPeriodInDays;
    private String launchType;
    private Date lastRefreshTimestamp;
    private String finding;
    private List<String> findingReasonCodes;
    private List<ECSServiceRecommendationOption> serviceRecommendationOptions;
    private String currentPerformanceRisk;
    private ECSEffectiveRecommendationPreferences effectiveRecommendationPreferences;
    private List<Tag> tags;

    public void setServiceArn(String serviceArn) {
        this.serviceArn = serviceArn;
    }

    public String getServiceArn() {
        return this.serviceArn;
    }

    public ECSServiceRecommendation withServiceArn(String serviceArn) {
        this.setServiceArn(serviceArn);
        return this;
    }

    public void setAccountId(String accountId) {
        this.accountId = accountId;
    }

    public String getAccountId() {
        return this.accountId;
    }

    public ECSServiceRecommendation withAccountId(String accountId) {
        this.setAccountId(accountId);
        return this;
    }

    public void setCurrentServiceConfiguration(ServiceConfiguration currentServiceConfiguration) {
        this.currentServiceConfiguration = currentServiceConfiguration;
    }

    public ServiceConfiguration getCurrentServiceConfiguration() {
        return this.currentServiceConfiguration;
    }

    public ECSServiceRecommendation withCurrentServiceConfiguration(ServiceConfiguration currentServiceConfiguration) {
        this.setCurrentServiceConfiguration(currentServiceConfiguration);
        return this;
    }

    public List<ECSServiceUtilizationMetric> getUtilizationMetrics() {
        return this.utilizationMetrics;
    }

    public void setUtilizationMetrics(Collection<ECSServiceUtilizationMetric> utilizationMetrics) {
        if (utilizationMetrics == null) {
            this.utilizationMetrics = null;
            return;
        }
        this.utilizationMetrics = new ArrayList<ECSServiceUtilizationMetric>(utilizationMetrics);
    }

    public ECSServiceRecommendation withUtilizationMetrics(ECSServiceUtilizationMetric ... utilizationMetrics) {
        if (this.utilizationMetrics == null) {
            this.setUtilizationMetrics(new ArrayList<ECSServiceUtilizationMetric>(utilizationMetrics.length));
        }
        for (ECSServiceUtilizationMetric ele : utilizationMetrics) {
            this.utilizationMetrics.add(ele);
        }
        return this;
    }

    public ECSServiceRecommendation withUtilizationMetrics(Collection<ECSServiceUtilizationMetric> utilizationMetrics) {
        this.setUtilizationMetrics(utilizationMetrics);
        return this;
    }

    public void setLookbackPeriodInDays(Double lookbackPeriodInDays) {
        this.lookbackPeriodInDays = lookbackPeriodInDays;
    }

    public Double getLookbackPeriodInDays() {
        return this.lookbackPeriodInDays;
    }

    public ECSServiceRecommendation withLookbackPeriodInDays(Double lookbackPeriodInDays) {
        this.setLookbackPeriodInDays(lookbackPeriodInDays);
        return this;
    }

    public void setLaunchType(String launchType) {
        this.launchType = launchType;
    }

    public String getLaunchType() {
        return this.launchType;
    }

    public ECSServiceRecommendation withLaunchType(String launchType) {
        this.setLaunchType(launchType);
        return this;
    }

    public ECSServiceRecommendation withLaunchType(ECSServiceLaunchType launchType) {
        this.launchType = launchType.toString();
        return this;
    }

    public void setLastRefreshTimestamp(Date lastRefreshTimestamp) {
        this.lastRefreshTimestamp = lastRefreshTimestamp;
    }

    public Date getLastRefreshTimestamp() {
        return this.lastRefreshTimestamp;
    }

    public ECSServiceRecommendation withLastRefreshTimestamp(Date lastRefreshTimestamp) {
        this.setLastRefreshTimestamp(lastRefreshTimestamp);
        return this;
    }

    public void setFinding(String finding) {
        this.finding = finding;
    }

    public String getFinding() {
        return this.finding;
    }

    public ECSServiceRecommendation withFinding(String finding) {
        this.setFinding(finding);
        return this;
    }

    public ECSServiceRecommendation withFinding(ECSServiceRecommendationFinding finding) {
        this.finding = finding.toString();
        return this;
    }

    public List<String> getFindingReasonCodes() {
        return this.findingReasonCodes;
    }

    public void setFindingReasonCodes(Collection<String> findingReasonCodes) {
        if (findingReasonCodes == null) {
            this.findingReasonCodes = null;
            return;
        }
        this.findingReasonCodes = new ArrayList<String>(findingReasonCodes);
    }

    public ECSServiceRecommendation withFindingReasonCodes(String ... findingReasonCodes) {
        if (this.findingReasonCodes == null) {
            this.setFindingReasonCodes(new ArrayList<String>(findingReasonCodes.length));
        }
        for (String ele : findingReasonCodes) {
            this.findingReasonCodes.add(ele);
        }
        return this;
    }

    public ECSServiceRecommendation withFindingReasonCodes(Collection<String> findingReasonCodes) {
        this.setFindingReasonCodes(findingReasonCodes);
        return this;
    }

    public ECSServiceRecommendation withFindingReasonCodes(ECSServiceRecommendationFindingReasonCode ... findingReasonCodes) {
        ArrayList<String> findingReasonCodesCopy = new ArrayList<String>(findingReasonCodes.length);
        for (ECSServiceRecommendationFindingReasonCode value : findingReasonCodes) {
            findingReasonCodesCopy.add(value.toString());
        }
        if (this.getFindingReasonCodes() == null) {
            this.setFindingReasonCodes(findingReasonCodesCopy);
        } else {
            this.getFindingReasonCodes().addAll(findingReasonCodesCopy);
        }
        return this;
    }

    public List<ECSServiceRecommendationOption> getServiceRecommendationOptions() {
        return this.serviceRecommendationOptions;
    }

    public void setServiceRecommendationOptions(Collection<ECSServiceRecommendationOption> serviceRecommendationOptions) {
        if (serviceRecommendationOptions == null) {
            this.serviceRecommendationOptions = null;
            return;
        }
        this.serviceRecommendationOptions = new ArrayList<ECSServiceRecommendationOption>(serviceRecommendationOptions);
    }

    public ECSServiceRecommendation withServiceRecommendationOptions(ECSServiceRecommendationOption ... serviceRecommendationOptions) {
        if (this.serviceRecommendationOptions == null) {
            this.setServiceRecommendationOptions(new ArrayList<ECSServiceRecommendationOption>(serviceRecommendationOptions.length));
        }
        for (ECSServiceRecommendationOption ele : serviceRecommendationOptions) {
            this.serviceRecommendationOptions.add(ele);
        }
        return this;
    }

    public ECSServiceRecommendation withServiceRecommendationOptions(Collection<ECSServiceRecommendationOption> serviceRecommendationOptions) {
        this.setServiceRecommendationOptions(serviceRecommendationOptions);
        return this;
    }

    public void setCurrentPerformanceRisk(String currentPerformanceRisk) {
        this.currentPerformanceRisk = currentPerformanceRisk;
    }

    public String getCurrentPerformanceRisk() {
        return this.currentPerformanceRisk;
    }

    public ECSServiceRecommendation withCurrentPerformanceRisk(String currentPerformanceRisk) {
        this.setCurrentPerformanceRisk(currentPerformanceRisk);
        return this;
    }

    public ECSServiceRecommendation withCurrentPerformanceRisk(CurrentPerformanceRisk currentPerformanceRisk) {
        this.currentPerformanceRisk = currentPerformanceRisk.toString();
        return this;
    }

    public void setEffectiveRecommendationPreferences(ECSEffectiveRecommendationPreferences effectiveRecommendationPreferences) {
        this.effectiveRecommendationPreferences = effectiveRecommendationPreferences;
    }

    public ECSEffectiveRecommendationPreferences getEffectiveRecommendationPreferences() {
        return this.effectiveRecommendationPreferences;
    }

    public ECSServiceRecommendation withEffectiveRecommendationPreferences(ECSEffectiveRecommendationPreferences effectiveRecommendationPreferences) {
        this.setEffectiveRecommendationPreferences(effectiveRecommendationPreferences);
        return this;
    }

    public List<Tag> getTags() {
        return this.tags;
    }

    public void setTags(Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }
        this.tags = new ArrayList<Tag>(tags);
    }

    public ECSServiceRecommendation withTags(Tag ... tags) {
        if (this.tags == null) {
            this.setTags(new ArrayList<Tag>(tags.length));
        }
        for (Tag ele : tags) {
            this.tags.add(ele);
        }
        return this;
    }

    public ECSServiceRecommendation withTags(Collection<Tag> tags) {
        this.setTags(tags);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getServiceArn() != null) {
            sb.append("ServiceArn: ").append(this.getServiceArn()).append(",");
        }
        if (this.getAccountId() != null) {
            sb.append("AccountId: ").append(this.getAccountId()).append(",");
        }
        if (this.getCurrentServiceConfiguration() != null) {
            sb.append("CurrentServiceConfiguration: ").append(this.getCurrentServiceConfiguration()).append(",");
        }
        if (this.getUtilizationMetrics() != null) {
            sb.append("UtilizationMetrics: ").append(this.getUtilizationMetrics()).append(",");
        }
        if (this.getLookbackPeriodInDays() != null) {
            sb.append("LookbackPeriodInDays: ").append(this.getLookbackPeriodInDays()).append(",");
        }
        if (this.getLaunchType() != null) {
            sb.append("LaunchType: ").append(this.getLaunchType()).append(",");
        }
        if (this.getLastRefreshTimestamp() != null) {
            sb.append("LastRefreshTimestamp: ").append(this.getLastRefreshTimestamp()).append(",");
        }
        if (this.getFinding() != null) {
            sb.append("Finding: ").append(this.getFinding()).append(",");
        }
        if (this.getFindingReasonCodes() != null) {
            sb.append("FindingReasonCodes: ").append(this.getFindingReasonCodes()).append(",");
        }
        if (this.getServiceRecommendationOptions() != null) {
            sb.append("ServiceRecommendationOptions: ").append(this.getServiceRecommendationOptions()).append(",");
        }
        if (this.getCurrentPerformanceRisk() != null) {
            sb.append("CurrentPerformanceRisk: ").append(this.getCurrentPerformanceRisk()).append(",");
        }
        if (this.getEffectiveRecommendationPreferences() != null) {
            sb.append("EffectiveRecommendationPreferences: ").append(this.getEffectiveRecommendationPreferences()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ECSServiceRecommendation)) {
            return false;
        }
        ECSServiceRecommendation other = (ECSServiceRecommendation)obj;
        if (other.getServiceArn() == null ^ this.getServiceArn() == null) {
            return false;
        }
        if (other.getServiceArn() != null && !other.getServiceArn().equals(this.getServiceArn())) {
            return false;
        }
        if (other.getAccountId() == null ^ this.getAccountId() == null) {
            return false;
        }
        if (other.getAccountId() != null && !other.getAccountId().equals(this.getAccountId())) {
            return false;
        }
        if (other.getCurrentServiceConfiguration() == null ^ this.getCurrentServiceConfiguration() == null) {
            return false;
        }
        if (other.getCurrentServiceConfiguration() != null && !other.getCurrentServiceConfiguration().equals(this.getCurrentServiceConfiguration())) {
            return false;
        }
        if (other.getUtilizationMetrics() == null ^ this.getUtilizationMetrics() == null) {
            return false;
        }
        if (other.getUtilizationMetrics() != null && !other.getUtilizationMetrics().equals(this.getUtilizationMetrics())) {
            return false;
        }
        if (other.getLookbackPeriodInDays() == null ^ this.getLookbackPeriodInDays() == null) {
            return false;
        }
        if (other.getLookbackPeriodInDays() != null && !other.getLookbackPeriodInDays().equals(this.getLookbackPeriodInDays())) {
            return false;
        }
        if (other.getLaunchType() == null ^ this.getLaunchType() == null) {
            return false;
        }
        if (other.getLaunchType() != null && !other.getLaunchType().equals(this.getLaunchType())) {
            return false;
        }
        if (other.getLastRefreshTimestamp() == null ^ this.getLastRefreshTimestamp() == null) {
            return false;
        }
        if (other.getLastRefreshTimestamp() != null && !other.getLastRefreshTimestamp().equals(this.getLastRefreshTimestamp())) {
            return false;
        }
        if (other.getFinding() == null ^ this.getFinding() == null) {
            return false;
        }
        if (other.getFinding() != null && !other.getFinding().equals(this.getFinding())) {
            return false;
        }
        if (other.getFindingReasonCodes() == null ^ this.getFindingReasonCodes() == null) {
            return false;
        }
        if (other.getFindingReasonCodes() != null && !other.getFindingReasonCodes().equals(this.getFindingReasonCodes())) {
            return false;
        }
        if (other.getServiceRecommendationOptions() == null ^ this.getServiceRecommendationOptions() == null) {
            return false;
        }
        if (other.getServiceRecommendationOptions() != null && !other.getServiceRecommendationOptions().equals(this.getServiceRecommendationOptions())) {
            return false;
        }
        if (other.getCurrentPerformanceRisk() == null ^ this.getCurrentPerformanceRisk() == null) {
            return false;
        }
        if (other.getCurrentPerformanceRisk() != null && !other.getCurrentPerformanceRisk().equals(this.getCurrentPerformanceRisk())) {
            return false;
        }
        if (other.getEffectiveRecommendationPreferences() == null ^ this.getEffectiveRecommendationPreferences() == null) {
            return false;
        }
        if (other.getEffectiveRecommendationPreferences() != null && !other.getEffectiveRecommendationPreferences().equals(this.getEffectiveRecommendationPreferences())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        return other.getTags() == null || other.getTags().equals(this.getTags());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getServiceArn() == null ? 0 : this.getServiceArn().hashCode());
        hashCode = 31 * hashCode + (this.getAccountId() == null ? 0 : this.getAccountId().hashCode());
        hashCode = 31 * hashCode + (this.getCurrentServiceConfiguration() == null ? 0 : this.getCurrentServiceConfiguration().hashCode());
        hashCode = 31 * hashCode + (this.getUtilizationMetrics() == null ? 0 : this.getUtilizationMetrics().hashCode());
        hashCode = 31 * hashCode + (this.getLookbackPeriodInDays() == null ? 0 : this.getLookbackPeriodInDays().hashCode());
        hashCode = 31 * hashCode + (this.getLaunchType() == null ? 0 : this.getLaunchType().hashCode());
        hashCode = 31 * hashCode + (this.getLastRefreshTimestamp() == null ? 0 : this.getLastRefreshTimestamp().hashCode());
        hashCode = 31 * hashCode + (this.getFinding() == null ? 0 : this.getFinding().hashCode());
        hashCode = 31 * hashCode + (this.getFindingReasonCodes() == null ? 0 : this.getFindingReasonCodes().hashCode());
        hashCode = 31 * hashCode + (this.getServiceRecommendationOptions() == null ? 0 : this.getServiceRecommendationOptions().hashCode());
        hashCode = 31 * hashCode + (this.getCurrentPerformanceRisk() == null ? 0 : this.getCurrentPerformanceRisk().hashCode());
        hashCode = 31 * hashCode + (this.getEffectiveRecommendationPreferences() == null ? 0 : this.getEffectiveRecommendationPreferences().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        return hashCode;
    }

    public ECSServiceRecommendation clone() {
        try {
            return (ECSServiceRecommendation)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ECSServiceRecommendationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

