/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.computeoptimizer.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.computeoptimizer.model.CpuVendorArchitecture;
import com.amazonaws.services.computeoptimizer.model.EnhancedInfrastructureMetrics;
import com.amazonaws.services.computeoptimizer.model.LookBackPeriodPreference;
import com.amazonaws.services.computeoptimizer.model.RDSSavingsEstimationMode;
import com.amazonaws.services.computeoptimizer.model.transform.RDSEffectiveRecommendationPreferencesMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class RDSEffectiveRecommendationPreferences
implements Serializable,
Cloneable,
StructuredPojo {
    private List<String> cpuVendorArchitectures;
    private String enhancedInfrastructureMetrics;
    private String lookBackPeriod;
    private RDSSavingsEstimationMode savingsEstimationMode;

    public List<String> getCpuVendorArchitectures() {
        return this.cpuVendorArchitectures;
    }

    public void setCpuVendorArchitectures(Collection<String> cpuVendorArchitectures) {
        if (cpuVendorArchitectures == null) {
            this.cpuVendorArchitectures = null;
            return;
        }
        this.cpuVendorArchitectures = new ArrayList<String>(cpuVendorArchitectures);
    }

    public RDSEffectiveRecommendationPreferences withCpuVendorArchitectures(String ... cpuVendorArchitectures) {
        if (this.cpuVendorArchitectures == null) {
            this.setCpuVendorArchitectures(new ArrayList<String>(cpuVendorArchitectures.length));
        }
        for (String ele : cpuVendorArchitectures) {
            this.cpuVendorArchitectures.add(ele);
        }
        return this;
    }

    public RDSEffectiveRecommendationPreferences withCpuVendorArchitectures(Collection<String> cpuVendorArchitectures) {
        this.setCpuVendorArchitectures(cpuVendorArchitectures);
        return this;
    }

    public RDSEffectiveRecommendationPreferences withCpuVendorArchitectures(CpuVendorArchitecture ... cpuVendorArchitectures) {
        ArrayList<String> cpuVendorArchitecturesCopy = new ArrayList<String>(cpuVendorArchitectures.length);
        for (CpuVendorArchitecture value : cpuVendorArchitectures) {
            cpuVendorArchitecturesCopy.add(value.toString());
        }
        if (this.getCpuVendorArchitectures() == null) {
            this.setCpuVendorArchitectures(cpuVendorArchitecturesCopy);
        } else {
            this.getCpuVendorArchitectures().addAll(cpuVendorArchitecturesCopy);
        }
        return this;
    }

    public void setEnhancedInfrastructureMetrics(String enhancedInfrastructureMetrics) {
        this.enhancedInfrastructureMetrics = enhancedInfrastructureMetrics;
    }

    public String getEnhancedInfrastructureMetrics() {
        return this.enhancedInfrastructureMetrics;
    }

    public RDSEffectiveRecommendationPreferences withEnhancedInfrastructureMetrics(String enhancedInfrastructureMetrics) {
        this.setEnhancedInfrastructureMetrics(enhancedInfrastructureMetrics);
        return this;
    }

    public RDSEffectiveRecommendationPreferences withEnhancedInfrastructureMetrics(EnhancedInfrastructureMetrics enhancedInfrastructureMetrics) {
        this.enhancedInfrastructureMetrics = enhancedInfrastructureMetrics.toString();
        return this;
    }

    public void setLookBackPeriod(String lookBackPeriod) {
        this.lookBackPeriod = lookBackPeriod;
    }

    public String getLookBackPeriod() {
        return this.lookBackPeriod;
    }

    public RDSEffectiveRecommendationPreferences withLookBackPeriod(String lookBackPeriod) {
        this.setLookBackPeriod(lookBackPeriod);
        return this;
    }

    public RDSEffectiveRecommendationPreferences withLookBackPeriod(LookBackPeriodPreference lookBackPeriod) {
        this.lookBackPeriod = lookBackPeriod.toString();
        return this;
    }

    public void setSavingsEstimationMode(RDSSavingsEstimationMode savingsEstimationMode) {
        this.savingsEstimationMode = savingsEstimationMode;
    }

    public RDSSavingsEstimationMode getSavingsEstimationMode() {
        return this.savingsEstimationMode;
    }

    public RDSEffectiveRecommendationPreferences withSavingsEstimationMode(RDSSavingsEstimationMode savingsEstimationMode) {
        this.setSavingsEstimationMode(savingsEstimationMode);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getCpuVendorArchitectures() != null) {
            sb.append("CpuVendorArchitectures: ").append(this.getCpuVendorArchitectures()).append(",");
        }
        if (this.getEnhancedInfrastructureMetrics() != null) {
            sb.append("EnhancedInfrastructureMetrics: ").append(this.getEnhancedInfrastructureMetrics()).append(",");
        }
        if (this.getLookBackPeriod() != null) {
            sb.append("LookBackPeriod: ").append(this.getLookBackPeriod()).append(",");
        }
        if (this.getSavingsEstimationMode() != null) {
            sb.append("SavingsEstimationMode: ").append(this.getSavingsEstimationMode());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RDSEffectiveRecommendationPreferences)) {
            return false;
        }
        RDSEffectiveRecommendationPreferences other = (RDSEffectiveRecommendationPreferences)obj;
        if (other.getCpuVendorArchitectures() == null ^ this.getCpuVendorArchitectures() == null) {
            return false;
        }
        if (other.getCpuVendorArchitectures() != null && !other.getCpuVendorArchitectures().equals(this.getCpuVendorArchitectures())) {
            return false;
        }
        if (other.getEnhancedInfrastructureMetrics() == null ^ this.getEnhancedInfrastructureMetrics() == null) {
            return false;
        }
        if (other.getEnhancedInfrastructureMetrics() != null && !other.getEnhancedInfrastructureMetrics().equals(this.getEnhancedInfrastructureMetrics())) {
            return false;
        }
        if (other.getLookBackPeriod() == null ^ this.getLookBackPeriod() == null) {
            return false;
        }
        if (other.getLookBackPeriod() != null && !other.getLookBackPeriod().equals(this.getLookBackPeriod())) {
            return false;
        }
        if (other.getSavingsEstimationMode() == null ^ this.getSavingsEstimationMode() == null) {
            return false;
        }
        return other.getSavingsEstimationMode() == null || other.getSavingsEstimationMode().equals(this.getSavingsEstimationMode());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getCpuVendorArchitectures() == null ? 0 : this.getCpuVendorArchitectures().hashCode());
        hashCode = 31 * hashCode + (this.getEnhancedInfrastructureMetrics() == null ? 0 : this.getEnhancedInfrastructureMetrics().hashCode());
        hashCode = 31 * hashCode + (this.getLookBackPeriod() == null ? 0 : this.getLookBackPeriod().hashCode());
        hashCode = 31 * hashCode + (this.getSavingsEstimationMode() == null ? 0 : this.getSavingsEstimationMode().hashCode());
        return hashCode;
    }

    public RDSEffectiveRecommendationPreferences clone() {
        try {
            return (RDSEffectiveRecommendationPreferences)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        RDSEffectiveRecommendationPreferencesMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

