/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.computeoptimizer.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.computeoptimizer.model.ServiceConfiguration;
import java.util.List;

@SdkInternalApi
public class ServiceConfigurationMarshaller {
    private static final MarshallingInfo<Integer> MEMORY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("memory").build();
    private static final MarshallingInfo<Integer> CPU_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("cpu").build();
    private static final MarshallingInfo<List> CONTAINERCONFIGURATIONS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("containerConfigurations").build();
    private static final MarshallingInfo<String> AUTOSCALINGCONFIGURATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("autoScalingConfiguration").build();
    private static final MarshallingInfo<String> TASKDEFINITIONARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("taskDefinitionArn").build();
    private static final ServiceConfigurationMarshaller instance = new ServiceConfigurationMarshaller();

    public static ServiceConfigurationMarshaller getInstance() {
        return instance;
    }

    public void marshall(ServiceConfiguration serviceConfiguration, ProtocolMarshaller protocolMarshaller) {
        if (serviceConfiguration == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)serviceConfiguration.getMemory(), MEMORY_BINDING);
            protocolMarshaller.marshall((Object)serviceConfiguration.getCpu(), CPU_BINDING);
            protocolMarshaller.marshall(serviceConfiguration.getContainerConfigurations(), CONTAINERCONFIGURATIONS_BINDING);
            protocolMarshaller.marshall((Object)serviceConfiguration.getAutoScalingConfiguration(), AUTOSCALINGCONFIGURATION_BINDING);
            protocolMarshaller.marshall((Object)serviceConfiguration.getTaskDefinitionArn(), TASKDEFINITIONARN_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

