/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.computeoptimizer;

import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.AmazonWebServiceResponse;
import com.amazonaws.ClientConfigurationFactory;
import com.amazonaws.Request;
import com.amazonaws.Response;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.client.builder.AdvancedConfig;
import com.amazonaws.handlers.HandlerChainFactory;
import com.amazonaws.handlers.HandlerContextKey;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.metrics.MetricType;
import com.amazonaws.protocol.json.JsonClientMetadata;
import com.amazonaws.protocol.json.JsonErrorResponseMetadata;
import com.amazonaws.protocol.json.JsonErrorShapeMetadata;
import com.amazonaws.protocol.json.JsonOperationMetadata;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.computeoptimizer.AWSComputeOptimizer;
import com.amazonaws.services.computeoptimizer.AWSComputeOptimizerClientBuilder;
import com.amazonaws.services.computeoptimizer.model.AWSComputeOptimizerException;
import com.amazonaws.services.computeoptimizer.model.DeleteRecommendationPreferencesRequest;
import com.amazonaws.services.computeoptimizer.model.DeleteRecommendationPreferencesResult;
import com.amazonaws.services.computeoptimizer.model.DescribeRecommendationExportJobsRequest;
import com.amazonaws.services.computeoptimizer.model.DescribeRecommendationExportJobsResult;
import com.amazonaws.services.computeoptimizer.model.ExportAutoScalingGroupRecommendationsRequest;
import com.amazonaws.services.computeoptimizer.model.ExportAutoScalingGroupRecommendationsResult;
import com.amazonaws.services.computeoptimizer.model.ExportEBSVolumeRecommendationsRequest;
import com.amazonaws.services.computeoptimizer.model.ExportEBSVolumeRecommendationsResult;
import com.amazonaws.services.computeoptimizer.model.ExportEC2InstanceRecommendationsRequest;
import com.amazonaws.services.computeoptimizer.model.ExportEC2InstanceRecommendationsResult;
import com.amazonaws.services.computeoptimizer.model.ExportECSServiceRecommendationsRequest;
import com.amazonaws.services.computeoptimizer.model.ExportECSServiceRecommendationsResult;
import com.amazonaws.services.computeoptimizer.model.ExportLambdaFunctionRecommendationsRequest;
import com.amazonaws.services.computeoptimizer.model.ExportLambdaFunctionRecommendationsResult;
import com.amazonaws.services.computeoptimizer.model.ExportLicenseRecommendationsRequest;
import com.amazonaws.services.computeoptimizer.model.ExportLicenseRecommendationsResult;
import com.amazonaws.services.computeoptimizer.model.GetAutoScalingGroupRecommendationsRequest;
import com.amazonaws.services.computeoptimizer.model.GetAutoScalingGroupRecommendationsResult;
import com.amazonaws.services.computeoptimizer.model.GetEBSVolumeRecommendationsRequest;
import com.amazonaws.services.computeoptimizer.model.GetEBSVolumeRecommendationsResult;
import com.amazonaws.services.computeoptimizer.model.GetEC2InstanceRecommendationsRequest;
import com.amazonaws.services.computeoptimizer.model.GetEC2InstanceRecommendationsResult;
import com.amazonaws.services.computeoptimizer.model.GetEC2RecommendationProjectedMetricsRequest;
import com.amazonaws.services.computeoptimizer.model.GetEC2RecommendationProjectedMetricsResult;
import com.amazonaws.services.computeoptimizer.model.GetECSServiceRecommendationProjectedMetricsRequest;
import com.amazonaws.services.computeoptimizer.model.GetECSServiceRecommendationProjectedMetricsResult;
import com.amazonaws.services.computeoptimizer.model.GetECSServiceRecommendationsRequest;
import com.amazonaws.services.computeoptimizer.model.GetECSServiceRecommendationsResult;
import com.amazonaws.services.computeoptimizer.model.GetEffectiveRecommendationPreferencesRequest;
import com.amazonaws.services.computeoptimizer.model.GetEffectiveRecommendationPreferencesResult;
import com.amazonaws.services.computeoptimizer.model.GetEnrollmentStatusRequest;
import com.amazonaws.services.computeoptimizer.model.GetEnrollmentStatusResult;
import com.amazonaws.services.computeoptimizer.model.GetEnrollmentStatusesForOrganizationRequest;
import com.amazonaws.services.computeoptimizer.model.GetEnrollmentStatusesForOrganizationResult;
import com.amazonaws.services.computeoptimizer.model.GetLambdaFunctionRecommendationsRequest;
import com.amazonaws.services.computeoptimizer.model.GetLambdaFunctionRecommendationsResult;
import com.amazonaws.services.computeoptimizer.model.GetLicenseRecommendationsRequest;
import com.amazonaws.services.computeoptimizer.model.GetLicenseRecommendationsResult;
import com.amazonaws.services.computeoptimizer.model.GetRecommendationPreferencesRequest;
import com.amazonaws.services.computeoptimizer.model.GetRecommendationPreferencesResult;
import com.amazonaws.services.computeoptimizer.model.GetRecommendationSummariesRequest;
import com.amazonaws.services.computeoptimizer.model.GetRecommendationSummariesResult;
import com.amazonaws.services.computeoptimizer.model.PutRecommendationPreferencesRequest;
import com.amazonaws.services.computeoptimizer.model.PutRecommendationPreferencesResult;
import com.amazonaws.services.computeoptimizer.model.UpdateEnrollmentStatusRequest;
import com.amazonaws.services.computeoptimizer.model.UpdateEnrollmentStatusResult;
import com.amazonaws.services.computeoptimizer.model.transform.AccessDeniedExceptionUnmarshaller;
import com.amazonaws.services.computeoptimizer.model.transform.DeleteRecommendationPreferencesRequestProtocolMarshaller;
import com.amazonaws.services.computeoptimizer.model.transform.DeleteRecommendationPreferencesResultJsonUnmarshaller;
import com.amazonaws.services.computeoptimizer.model.transform.DescribeRecommendationExportJobsRequestProtocolMarshaller;
import com.amazonaws.services.computeoptimizer.model.transform.DescribeRecommendationExportJobsResultJsonUnmarshaller;
import com.amazonaws.services.computeoptimizer.model.transform.ExportAutoScalingGroupRecommendationsRequestProtocolMarshaller;
import com.amazonaws.services.computeoptimizer.model.transform.ExportAutoScalingGroupRecommendationsResultJsonUnmarshaller;
import com.amazonaws.services.computeoptimizer.model.transform.ExportEBSVolumeRecommendationsRequestProtocolMarshaller;
import com.amazonaws.services.computeoptimizer.model.transform.ExportEBSVolumeRecommendationsResultJsonUnmarshaller;
import com.amazonaws.services.computeoptimizer.model.transform.ExportEC2InstanceRecommendationsRequestProtocolMarshaller;
import com.amazonaws.services.computeoptimizer.model.transform.ExportEC2InstanceRecommendationsResultJsonUnmarshaller;
import com.amazonaws.services.computeoptimizer.model.transform.ExportECSServiceRecommendationsRequestProtocolMarshaller;
import com.amazonaws.services.computeoptimizer.model.transform.ExportECSServiceRecommendationsResultJsonUnmarshaller;
import com.amazonaws.services.computeoptimizer.model.transform.ExportLambdaFunctionRecommendationsRequestProtocolMarshaller;
import com.amazonaws.services.computeoptimizer.model.transform.ExportLambdaFunctionRecommendationsResultJsonUnmarshaller;
import com.amazonaws.services.computeoptimizer.model.transform.ExportLicenseRecommendationsRequestProtocolMarshaller;
import com.amazonaws.services.computeoptimizer.model.transform.ExportLicenseRecommendationsResultJsonUnmarshaller;
import com.amazonaws.services.computeoptimizer.model.transform.GetAutoScalingGroupRecommendationsRequestProtocolMarshaller;
import com.amazonaws.services.computeoptimizer.model.transform.GetAutoScalingGroupRecommendationsResultJsonUnmarshaller;
import com.amazonaws.services.computeoptimizer.model.transform.GetEBSVolumeRecommendationsRequestProtocolMarshaller;
import com.amazonaws.services.computeoptimizer.model.transform.GetEBSVolumeRecommendationsResultJsonUnmarshaller;
import com.amazonaws.services.computeoptimizer.model.transform.GetEC2InstanceRecommendationsRequestProtocolMarshaller;
import com.amazonaws.services.computeoptimizer.model.transform.GetEC2InstanceRecommendationsResultJsonUnmarshaller;
import com.amazonaws.services.computeoptimizer.model.transform.GetEC2RecommendationProjectedMetricsRequestProtocolMarshaller;
import com.amazonaws.services.computeoptimizer.model.transform.GetEC2RecommendationProjectedMetricsResultJsonUnmarshaller;
import com.amazonaws.services.computeoptimizer.model.transform.GetECSServiceRecommendationProjectedMetricsRequestProtocolMarshaller;
import com.amazonaws.services.computeoptimizer.model.transform.GetECSServiceRecommendationProjectedMetricsResultJsonUnmarshaller;
import com.amazonaws.services.computeoptimizer.model.transform.GetECSServiceRecommendationsRequestProtocolMarshaller;
import com.amazonaws.services.computeoptimizer.model.transform.GetECSServiceRecommendationsResultJsonUnmarshaller;
import com.amazonaws.services.computeoptimizer.model.transform.GetEffectiveRecommendationPreferencesRequestProtocolMarshaller;
import com.amazonaws.services.computeoptimizer.model.transform.GetEffectiveRecommendationPreferencesResultJsonUnmarshaller;
import com.amazonaws.services.computeoptimizer.model.transform.GetEnrollmentStatusRequestProtocolMarshaller;
import com.amazonaws.services.computeoptimizer.model.transform.GetEnrollmentStatusResultJsonUnmarshaller;
import com.amazonaws.services.computeoptimizer.model.transform.GetEnrollmentStatusesForOrganizationRequestProtocolMarshaller;
import com.amazonaws.services.computeoptimizer.model.transform.GetEnrollmentStatusesForOrganizationResultJsonUnmarshaller;
import com.amazonaws.services.computeoptimizer.model.transform.GetLambdaFunctionRecommendationsRequestProtocolMarshaller;
import com.amazonaws.services.computeoptimizer.model.transform.GetLambdaFunctionRecommendationsResultJsonUnmarshaller;
import com.amazonaws.services.computeoptimizer.model.transform.GetLicenseRecommendationsRequestProtocolMarshaller;
import com.amazonaws.services.computeoptimizer.model.transform.GetLicenseRecommendationsResultJsonUnmarshaller;
import com.amazonaws.services.computeoptimizer.model.transform.GetRecommendationPreferencesRequestProtocolMarshaller;
import com.amazonaws.services.computeoptimizer.model.transform.GetRecommendationPreferencesResultJsonUnmarshaller;
import com.amazonaws.services.computeoptimizer.model.transform.GetRecommendationSummariesRequestProtocolMarshaller;
import com.amazonaws.services.computeoptimizer.model.transform.GetRecommendationSummariesResultJsonUnmarshaller;
import com.amazonaws.services.computeoptimizer.model.transform.InternalServerExceptionUnmarshaller;
import com.amazonaws.services.computeoptimizer.model.transform.InvalidParameterValueExceptionUnmarshaller;
import com.amazonaws.services.computeoptimizer.model.transform.LimitExceededExceptionUnmarshaller;
import com.amazonaws.services.computeoptimizer.model.transform.MissingAuthenticationTokenExceptionUnmarshaller;
import com.amazonaws.services.computeoptimizer.model.transform.OptInRequiredExceptionUnmarshaller;
import com.amazonaws.services.computeoptimizer.model.transform.PutRecommendationPreferencesRequestProtocolMarshaller;
import com.amazonaws.services.computeoptimizer.model.transform.PutRecommendationPreferencesResultJsonUnmarshaller;
import com.amazonaws.services.computeoptimizer.model.transform.ResourceNotFoundExceptionUnmarshaller;
import com.amazonaws.services.computeoptimizer.model.transform.ServiceUnavailableExceptionUnmarshaller;
import com.amazonaws.services.computeoptimizer.model.transform.ThrottlingExceptionUnmarshaller;
import com.amazonaws.services.computeoptimizer.model.transform.UpdateEnrollmentStatusRequestProtocolMarshaller;
import com.amazonaws.services.computeoptimizer.model.transform.UpdateEnrollmentStatusResultJsonUnmarshaller;
import com.amazonaws.transform.JsonErrorUnmarshaller;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.AWSRequestMetrics;
import com.amazonaws.util.CredentialUtils;
import java.net.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@ThreadSafe
public class AWSComputeOptimizerClient
extends AmazonWebServiceClient
implements AWSComputeOptimizer {
    private final AWSCredentialsProvider awsCredentialsProvider;
    private static final Log log = LogFactory.getLog(AWSComputeOptimizer.class);
    private static final String DEFAULT_SIGNING_NAME = "compute-optimizer";
    protected static final ClientConfigurationFactory configFactory = new ClientConfigurationFactory();
    private final AdvancedConfig advancedConfig;
    private static final SdkJsonProtocolFactory protocolFactory = new SdkJsonProtocolFactory(new JsonClientMetadata().withProtocolVersion("1.0").withSupportsCbor(false).withSupportsIon(false).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidParameterValueException").withExceptionUnmarshaller((JsonErrorUnmarshaller)InvalidParameterValueExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ThrottlingException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ThrottlingExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("OptInRequiredException").withExceptionUnmarshaller((JsonErrorUnmarshaller)OptInRequiredExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InternalServerException").withExceptionUnmarshaller((JsonErrorUnmarshaller)InternalServerExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("LimitExceededException").withExceptionUnmarshaller((JsonErrorUnmarshaller)LimitExceededExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("AccessDeniedException").withExceptionUnmarshaller((JsonErrorUnmarshaller)AccessDeniedExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ResourceNotFoundException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ResourceNotFoundExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("MissingAuthenticationToken").withExceptionUnmarshaller((JsonErrorUnmarshaller)MissingAuthenticationTokenExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ServiceUnavailableException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ServiceUnavailableExceptionUnmarshaller.getInstance())).withBaseServiceExceptionClass(AWSComputeOptimizerException.class));

    public static AWSComputeOptimizerClientBuilder builder() {
        return AWSComputeOptimizerClientBuilder.standard();
    }

    AWSComputeOptimizerClient(AwsSyncClientParams clientParams) {
        this(clientParams, false);
    }

    AWSComputeOptimizerClient(AwsSyncClientParams clientParams, boolean endpointDiscoveryEnabled) {
        super(clientParams);
        this.awsCredentialsProvider = clientParams.getCredentialsProvider();
        this.advancedConfig = clientParams.getAdvancedConfig();
        this.init();
    }

    private void init() {
        this.setServiceNameIntern(DEFAULT_SIGNING_NAME);
        this.setEndpointPrefix(DEFAULT_SIGNING_NAME);
        this.setEndpoint("compute-optimizer.us-east-1.amazonaws.com");
        HandlerChainFactory chainFactory = new HandlerChainFactory();
        this.requestHandler2s.addAll(chainFactory.newRequestHandlerChain("/com/amazonaws/services/computeoptimizer/request.handlers"));
        this.requestHandler2s.addAll(chainFactory.newRequestHandler2Chain("/com/amazonaws/services/computeoptimizer/request.handler2s"));
        this.requestHandler2s.addAll(chainFactory.getGlobalHandlers());
    }

    @Override
    public DeleteRecommendationPreferencesResult deleteRecommendationPreferences(DeleteRecommendationPreferencesRequest request) {
        request = (DeleteRecommendationPreferencesRequest)this.beforeClientExecution(request);
        return this.executeDeleteRecommendationPreferences(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteRecommendationPreferencesResult executeDeleteRecommendationPreferences(DeleteRecommendationPreferencesRequest deleteRecommendationPreferencesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteRecommendationPreferencesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteRecommendationPreferencesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteRecommendationPreferencesRequestProtocolMarshaller(protocolFactory).marshall((DeleteRecommendationPreferencesRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteRecommendationPreferencesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Compute Optimizer");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeleteRecommendationPreferences");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteRecommendationPreferencesResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteRecommendationPreferencesResult deleteRecommendationPreferencesResult = (DeleteRecommendationPreferencesResult)response.getAwsResponse();
            return deleteRecommendationPreferencesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeRecommendationExportJobsResult describeRecommendationExportJobs(DescribeRecommendationExportJobsRequest request) {
        request = (DescribeRecommendationExportJobsRequest)this.beforeClientExecution(request);
        return this.executeDescribeRecommendationExportJobs(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeRecommendationExportJobsResult executeDescribeRecommendationExportJobs(DescribeRecommendationExportJobsRequest describeRecommendationExportJobsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeRecommendationExportJobsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeRecommendationExportJobsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeRecommendationExportJobsRequestProtocolMarshaller(protocolFactory).marshall((DescribeRecommendationExportJobsRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeRecommendationExportJobsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Compute Optimizer");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DescribeRecommendationExportJobs");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeRecommendationExportJobsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeRecommendationExportJobsResult describeRecommendationExportJobsResult = (DescribeRecommendationExportJobsResult)response.getAwsResponse();
            return describeRecommendationExportJobsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ExportAutoScalingGroupRecommendationsResult exportAutoScalingGroupRecommendations(ExportAutoScalingGroupRecommendationsRequest request) {
        request = (ExportAutoScalingGroupRecommendationsRequest)this.beforeClientExecution(request);
        return this.executeExportAutoScalingGroupRecommendations(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ExportAutoScalingGroupRecommendationsResult executeExportAutoScalingGroupRecommendations(ExportAutoScalingGroupRecommendationsRequest exportAutoScalingGroupRecommendationsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(exportAutoScalingGroupRecommendationsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ExportAutoScalingGroupRecommendationsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ExportAutoScalingGroupRecommendationsRequestProtocolMarshaller(protocolFactory).marshall((ExportAutoScalingGroupRecommendationsRequest)super.beforeMarshalling((AmazonWebServiceRequest)exportAutoScalingGroupRecommendationsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Compute Optimizer");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ExportAutoScalingGroupRecommendations");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ExportAutoScalingGroupRecommendationsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ExportAutoScalingGroupRecommendationsResult exportAutoScalingGroupRecommendationsResult = (ExportAutoScalingGroupRecommendationsResult)response.getAwsResponse();
            return exportAutoScalingGroupRecommendationsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ExportEBSVolumeRecommendationsResult exportEBSVolumeRecommendations(ExportEBSVolumeRecommendationsRequest request) {
        request = (ExportEBSVolumeRecommendationsRequest)this.beforeClientExecution(request);
        return this.executeExportEBSVolumeRecommendations(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ExportEBSVolumeRecommendationsResult executeExportEBSVolumeRecommendations(ExportEBSVolumeRecommendationsRequest exportEBSVolumeRecommendationsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(exportEBSVolumeRecommendationsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ExportEBSVolumeRecommendationsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ExportEBSVolumeRecommendationsRequestProtocolMarshaller(protocolFactory).marshall((ExportEBSVolumeRecommendationsRequest)super.beforeMarshalling((AmazonWebServiceRequest)exportEBSVolumeRecommendationsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Compute Optimizer");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ExportEBSVolumeRecommendations");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ExportEBSVolumeRecommendationsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ExportEBSVolumeRecommendationsResult exportEBSVolumeRecommendationsResult = (ExportEBSVolumeRecommendationsResult)response.getAwsResponse();
            return exportEBSVolumeRecommendationsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ExportEC2InstanceRecommendationsResult exportEC2InstanceRecommendations(ExportEC2InstanceRecommendationsRequest request) {
        request = (ExportEC2InstanceRecommendationsRequest)this.beforeClientExecution(request);
        return this.executeExportEC2InstanceRecommendations(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ExportEC2InstanceRecommendationsResult executeExportEC2InstanceRecommendations(ExportEC2InstanceRecommendationsRequest exportEC2InstanceRecommendationsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(exportEC2InstanceRecommendationsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ExportEC2InstanceRecommendationsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ExportEC2InstanceRecommendationsRequestProtocolMarshaller(protocolFactory).marshall((ExportEC2InstanceRecommendationsRequest)super.beforeMarshalling((AmazonWebServiceRequest)exportEC2InstanceRecommendationsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Compute Optimizer");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ExportEC2InstanceRecommendations");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ExportEC2InstanceRecommendationsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ExportEC2InstanceRecommendationsResult exportEC2InstanceRecommendationsResult = (ExportEC2InstanceRecommendationsResult)response.getAwsResponse();
            return exportEC2InstanceRecommendationsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ExportECSServiceRecommendationsResult exportECSServiceRecommendations(ExportECSServiceRecommendationsRequest request) {
        request = (ExportECSServiceRecommendationsRequest)this.beforeClientExecution(request);
        return this.executeExportECSServiceRecommendations(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ExportECSServiceRecommendationsResult executeExportECSServiceRecommendations(ExportECSServiceRecommendationsRequest exportECSServiceRecommendationsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(exportECSServiceRecommendationsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ExportECSServiceRecommendationsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ExportECSServiceRecommendationsRequestProtocolMarshaller(protocolFactory).marshall((ExportECSServiceRecommendationsRequest)super.beforeMarshalling((AmazonWebServiceRequest)exportECSServiceRecommendationsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Compute Optimizer");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ExportECSServiceRecommendations");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ExportECSServiceRecommendationsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ExportECSServiceRecommendationsResult exportECSServiceRecommendationsResult = (ExportECSServiceRecommendationsResult)response.getAwsResponse();
            return exportECSServiceRecommendationsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ExportLambdaFunctionRecommendationsResult exportLambdaFunctionRecommendations(ExportLambdaFunctionRecommendationsRequest request) {
        request = (ExportLambdaFunctionRecommendationsRequest)this.beforeClientExecution(request);
        return this.executeExportLambdaFunctionRecommendations(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ExportLambdaFunctionRecommendationsResult executeExportLambdaFunctionRecommendations(ExportLambdaFunctionRecommendationsRequest exportLambdaFunctionRecommendationsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(exportLambdaFunctionRecommendationsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ExportLambdaFunctionRecommendationsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ExportLambdaFunctionRecommendationsRequestProtocolMarshaller(protocolFactory).marshall((ExportLambdaFunctionRecommendationsRequest)super.beforeMarshalling((AmazonWebServiceRequest)exportLambdaFunctionRecommendationsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Compute Optimizer");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ExportLambdaFunctionRecommendations");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ExportLambdaFunctionRecommendationsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ExportLambdaFunctionRecommendationsResult exportLambdaFunctionRecommendationsResult = (ExportLambdaFunctionRecommendationsResult)response.getAwsResponse();
            return exportLambdaFunctionRecommendationsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ExportLicenseRecommendationsResult exportLicenseRecommendations(ExportLicenseRecommendationsRequest request) {
        request = (ExportLicenseRecommendationsRequest)this.beforeClientExecution(request);
        return this.executeExportLicenseRecommendations(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ExportLicenseRecommendationsResult executeExportLicenseRecommendations(ExportLicenseRecommendationsRequest exportLicenseRecommendationsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(exportLicenseRecommendationsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ExportLicenseRecommendationsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ExportLicenseRecommendationsRequestProtocolMarshaller(protocolFactory).marshall((ExportLicenseRecommendationsRequest)super.beforeMarshalling((AmazonWebServiceRequest)exportLicenseRecommendationsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Compute Optimizer");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ExportLicenseRecommendations");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ExportLicenseRecommendationsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ExportLicenseRecommendationsResult exportLicenseRecommendationsResult = (ExportLicenseRecommendationsResult)response.getAwsResponse();
            return exportLicenseRecommendationsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetAutoScalingGroupRecommendationsResult getAutoScalingGroupRecommendations(GetAutoScalingGroupRecommendationsRequest request) {
        request = (GetAutoScalingGroupRecommendationsRequest)this.beforeClientExecution(request);
        return this.executeGetAutoScalingGroupRecommendations(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetAutoScalingGroupRecommendationsResult executeGetAutoScalingGroupRecommendations(GetAutoScalingGroupRecommendationsRequest getAutoScalingGroupRecommendationsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getAutoScalingGroupRecommendationsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetAutoScalingGroupRecommendationsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetAutoScalingGroupRecommendationsRequestProtocolMarshaller(protocolFactory).marshall((GetAutoScalingGroupRecommendationsRequest)super.beforeMarshalling((AmazonWebServiceRequest)getAutoScalingGroupRecommendationsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Compute Optimizer");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetAutoScalingGroupRecommendations");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetAutoScalingGroupRecommendationsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetAutoScalingGroupRecommendationsResult getAutoScalingGroupRecommendationsResult = (GetAutoScalingGroupRecommendationsResult)response.getAwsResponse();
            return getAutoScalingGroupRecommendationsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetEBSVolumeRecommendationsResult getEBSVolumeRecommendations(GetEBSVolumeRecommendationsRequest request) {
        request = (GetEBSVolumeRecommendationsRequest)this.beforeClientExecution(request);
        return this.executeGetEBSVolumeRecommendations(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetEBSVolumeRecommendationsResult executeGetEBSVolumeRecommendations(GetEBSVolumeRecommendationsRequest getEBSVolumeRecommendationsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getEBSVolumeRecommendationsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetEBSVolumeRecommendationsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetEBSVolumeRecommendationsRequestProtocolMarshaller(protocolFactory).marshall((GetEBSVolumeRecommendationsRequest)super.beforeMarshalling((AmazonWebServiceRequest)getEBSVolumeRecommendationsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Compute Optimizer");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetEBSVolumeRecommendations");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetEBSVolumeRecommendationsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetEBSVolumeRecommendationsResult getEBSVolumeRecommendationsResult = (GetEBSVolumeRecommendationsResult)response.getAwsResponse();
            return getEBSVolumeRecommendationsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetEC2InstanceRecommendationsResult getEC2InstanceRecommendations(GetEC2InstanceRecommendationsRequest request) {
        request = (GetEC2InstanceRecommendationsRequest)this.beforeClientExecution(request);
        return this.executeGetEC2InstanceRecommendations(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetEC2InstanceRecommendationsResult executeGetEC2InstanceRecommendations(GetEC2InstanceRecommendationsRequest getEC2InstanceRecommendationsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getEC2InstanceRecommendationsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetEC2InstanceRecommendationsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetEC2InstanceRecommendationsRequestProtocolMarshaller(protocolFactory).marshall((GetEC2InstanceRecommendationsRequest)super.beforeMarshalling((AmazonWebServiceRequest)getEC2InstanceRecommendationsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Compute Optimizer");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetEC2InstanceRecommendations");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetEC2InstanceRecommendationsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetEC2InstanceRecommendationsResult getEC2InstanceRecommendationsResult = (GetEC2InstanceRecommendationsResult)response.getAwsResponse();
            return getEC2InstanceRecommendationsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetEC2RecommendationProjectedMetricsResult getEC2RecommendationProjectedMetrics(GetEC2RecommendationProjectedMetricsRequest request) {
        request = (GetEC2RecommendationProjectedMetricsRequest)this.beforeClientExecution(request);
        return this.executeGetEC2RecommendationProjectedMetrics(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetEC2RecommendationProjectedMetricsResult executeGetEC2RecommendationProjectedMetrics(GetEC2RecommendationProjectedMetricsRequest getEC2RecommendationProjectedMetricsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getEC2RecommendationProjectedMetricsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetEC2RecommendationProjectedMetricsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetEC2RecommendationProjectedMetricsRequestProtocolMarshaller(protocolFactory).marshall((GetEC2RecommendationProjectedMetricsRequest)super.beforeMarshalling((AmazonWebServiceRequest)getEC2RecommendationProjectedMetricsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Compute Optimizer");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetEC2RecommendationProjectedMetrics");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetEC2RecommendationProjectedMetricsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetEC2RecommendationProjectedMetricsResult getEC2RecommendationProjectedMetricsResult = (GetEC2RecommendationProjectedMetricsResult)response.getAwsResponse();
            return getEC2RecommendationProjectedMetricsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetECSServiceRecommendationProjectedMetricsResult getECSServiceRecommendationProjectedMetrics(GetECSServiceRecommendationProjectedMetricsRequest request) {
        request = (GetECSServiceRecommendationProjectedMetricsRequest)this.beforeClientExecution(request);
        return this.executeGetECSServiceRecommendationProjectedMetrics(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetECSServiceRecommendationProjectedMetricsResult executeGetECSServiceRecommendationProjectedMetrics(GetECSServiceRecommendationProjectedMetricsRequest getECSServiceRecommendationProjectedMetricsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getECSServiceRecommendationProjectedMetricsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetECSServiceRecommendationProjectedMetricsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetECSServiceRecommendationProjectedMetricsRequestProtocolMarshaller(protocolFactory).marshall((GetECSServiceRecommendationProjectedMetricsRequest)super.beforeMarshalling((AmazonWebServiceRequest)getECSServiceRecommendationProjectedMetricsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Compute Optimizer");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetECSServiceRecommendationProjectedMetrics");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetECSServiceRecommendationProjectedMetricsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetECSServiceRecommendationProjectedMetricsResult getECSServiceRecommendationProjectedMetricsResult = (GetECSServiceRecommendationProjectedMetricsResult)response.getAwsResponse();
            return getECSServiceRecommendationProjectedMetricsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetECSServiceRecommendationsResult getECSServiceRecommendations(GetECSServiceRecommendationsRequest request) {
        request = (GetECSServiceRecommendationsRequest)this.beforeClientExecution(request);
        return this.executeGetECSServiceRecommendations(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetECSServiceRecommendationsResult executeGetECSServiceRecommendations(GetECSServiceRecommendationsRequest getECSServiceRecommendationsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getECSServiceRecommendationsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetECSServiceRecommendationsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetECSServiceRecommendationsRequestProtocolMarshaller(protocolFactory).marshall((GetECSServiceRecommendationsRequest)super.beforeMarshalling((AmazonWebServiceRequest)getECSServiceRecommendationsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Compute Optimizer");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetECSServiceRecommendations");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetECSServiceRecommendationsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetECSServiceRecommendationsResult getECSServiceRecommendationsResult = (GetECSServiceRecommendationsResult)response.getAwsResponse();
            return getECSServiceRecommendationsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetEffectiveRecommendationPreferencesResult getEffectiveRecommendationPreferences(GetEffectiveRecommendationPreferencesRequest request) {
        request = (GetEffectiveRecommendationPreferencesRequest)this.beforeClientExecution(request);
        return this.executeGetEffectiveRecommendationPreferences(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetEffectiveRecommendationPreferencesResult executeGetEffectiveRecommendationPreferences(GetEffectiveRecommendationPreferencesRequest getEffectiveRecommendationPreferencesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getEffectiveRecommendationPreferencesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetEffectiveRecommendationPreferencesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetEffectiveRecommendationPreferencesRequestProtocolMarshaller(protocolFactory).marshall((GetEffectiveRecommendationPreferencesRequest)super.beforeMarshalling((AmazonWebServiceRequest)getEffectiveRecommendationPreferencesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Compute Optimizer");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetEffectiveRecommendationPreferences");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetEffectiveRecommendationPreferencesResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetEffectiveRecommendationPreferencesResult getEffectiveRecommendationPreferencesResult = (GetEffectiveRecommendationPreferencesResult)response.getAwsResponse();
            return getEffectiveRecommendationPreferencesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetEnrollmentStatusResult getEnrollmentStatus(GetEnrollmentStatusRequest request) {
        request = (GetEnrollmentStatusRequest)this.beforeClientExecution(request);
        return this.executeGetEnrollmentStatus(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetEnrollmentStatusResult executeGetEnrollmentStatus(GetEnrollmentStatusRequest getEnrollmentStatusRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getEnrollmentStatusRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetEnrollmentStatusRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetEnrollmentStatusRequestProtocolMarshaller(protocolFactory).marshall((GetEnrollmentStatusRequest)super.beforeMarshalling((AmazonWebServiceRequest)getEnrollmentStatusRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Compute Optimizer");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetEnrollmentStatus");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetEnrollmentStatusResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetEnrollmentStatusResult getEnrollmentStatusResult = (GetEnrollmentStatusResult)response.getAwsResponse();
            return getEnrollmentStatusResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetEnrollmentStatusesForOrganizationResult getEnrollmentStatusesForOrganization(GetEnrollmentStatusesForOrganizationRequest request) {
        request = (GetEnrollmentStatusesForOrganizationRequest)this.beforeClientExecution(request);
        return this.executeGetEnrollmentStatusesForOrganization(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetEnrollmentStatusesForOrganizationResult executeGetEnrollmentStatusesForOrganization(GetEnrollmentStatusesForOrganizationRequest getEnrollmentStatusesForOrganizationRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getEnrollmentStatusesForOrganizationRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetEnrollmentStatusesForOrganizationRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetEnrollmentStatusesForOrganizationRequestProtocolMarshaller(protocolFactory).marshall((GetEnrollmentStatusesForOrganizationRequest)super.beforeMarshalling((AmazonWebServiceRequest)getEnrollmentStatusesForOrganizationRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Compute Optimizer");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetEnrollmentStatusesForOrganization");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetEnrollmentStatusesForOrganizationResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetEnrollmentStatusesForOrganizationResult getEnrollmentStatusesForOrganizationResult = (GetEnrollmentStatusesForOrganizationResult)response.getAwsResponse();
            return getEnrollmentStatusesForOrganizationResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetLambdaFunctionRecommendationsResult getLambdaFunctionRecommendations(GetLambdaFunctionRecommendationsRequest request) {
        request = (GetLambdaFunctionRecommendationsRequest)this.beforeClientExecution(request);
        return this.executeGetLambdaFunctionRecommendations(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetLambdaFunctionRecommendationsResult executeGetLambdaFunctionRecommendations(GetLambdaFunctionRecommendationsRequest getLambdaFunctionRecommendationsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getLambdaFunctionRecommendationsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetLambdaFunctionRecommendationsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetLambdaFunctionRecommendationsRequestProtocolMarshaller(protocolFactory).marshall((GetLambdaFunctionRecommendationsRequest)super.beforeMarshalling((AmazonWebServiceRequest)getLambdaFunctionRecommendationsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Compute Optimizer");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetLambdaFunctionRecommendations");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetLambdaFunctionRecommendationsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetLambdaFunctionRecommendationsResult getLambdaFunctionRecommendationsResult = (GetLambdaFunctionRecommendationsResult)response.getAwsResponse();
            return getLambdaFunctionRecommendationsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetLicenseRecommendationsResult getLicenseRecommendations(GetLicenseRecommendationsRequest request) {
        request = (GetLicenseRecommendationsRequest)this.beforeClientExecution(request);
        return this.executeGetLicenseRecommendations(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetLicenseRecommendationsResult executeGetLicenseRecommendations(GetLicenseRecommendationsRequest getLicenseRecommendationsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getLicenseRecommendationsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetLicenseRecommendationsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetLicenseRecommendationsRequestProtocolMarshaller(protocolFactory).marshall((GetLicenseRecommendationsRequest)super.beforeMarshalling((AmazonWebServiceRequest)getLicenseRecommendationsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Compute Optimizer");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetLicenseRecommendations");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetLicenseRecommendationsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetLicenseRecommendationsResult getLicenseRecommendationsResult = (GetLicenseRecommendationsResult)response.getAwsResponse();
            return getLicenseRecommendationsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetRecommendationPreferencesResult getRecommendationPreferences(GetRecommendationPreferencesRequest request) {
        request = (GetRecommendationPreferencesRequest)this.beforeClientExecution(request);
        return this.executeGetRecommendationPreferences(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetRecommendationPreferencesResult executeGetRecommendationPreferences(GetRecommendationPreferencesRequest getRecommendationPreferencesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getRecommendationPreferencesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetRecommendationPreferencesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetRecommendationPreferencesRequestProtocolMarshaller(protocolFactory).marshall((GetRecommendationPreferencesRequest)super.beforeMarshalling((AmazonWebServiceRequest)getRecommendationPreferencesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Compute Optimizer");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetRecommendationPreferences");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetRecommendationPreferencesResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetRecommendationPreferencesResult getRecommendationPreferencesResult = (GetRecommendationPreferencesResult)response.getAwsResponse();
            return getRecommendationPreferencesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetRecommendationSummariesResult getRecommendationSummaries(GetRecommendationSummariesRequest request) {
        request = (GetRecommendationSummariesRequest)this.beforeClientExecution(request);
        return this.executeGetRecommendationSummaries(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetRecommendationSummariesResult executeGetRecommendationSummaries(GetRecommendationSummariesRequest getRecommendationSummariesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getRecommendationSummariesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetRecommendationSummariesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetRecommendationSummariesRequestProtocolMarshaller(protocolFactory).marshall((GetRecommendationSummariesRequest)super.beforeMarshalling((AmazonWebServiceRequest)getRecommendationSummariesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Compute Optimizer");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetRecommendationSummaries");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetRecommendationSummariesResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetRecommendationSummariesResult getRecommendationSummariesResult = (GetRecommendationSummariesResult)response.getAwsResponse();
            return getRecommendationSummariesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public PutRecommendationPreferencesResult putRecommendationPreferences(PutRecommendationPreferencesRequest request) {
        request = (PutRecommendationPreferencesRequest)this.beforeClientExecution(request);
        return this.executePutRecommendationPreferences(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final PutRecommendationPreferencesResult executePutRecommendationPreferences(PutRecommendationPreferencesRequest putRecommendationPreferencesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(putRecommendationPreferencesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<PutRecommendationPreferencesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new PutRecommendationPreferencesRequestProtocolMarshaller(protocolFactory).marshall((PutRecommendationPreferencesRequest)super.beforeMarshalling((AmazonWebServiceRequest)putRecommendationPreferencesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Compute Optimizer");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"PutRecommendationPreferences");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new PutRecommendationPreferencesResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            PutRecommendationPreferencesResult putRecommendationPreferencesResult = (PutRecommendationPreferencesResult)response.getAwsResponse();
            return putRecommendationPreferencesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UpdateEnrollmentStatusResult updateEnrollmentStatus(UpdateEnrollmentStatusRequest request) {
        request = (UpdateEnrollmentStatusRequest)this.beforeClientExecution(request);
        return this.executeUpdateEnrollmentStatus(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UpdateEnrollmentStatusResult executeUpdateEnrollmentStatus(UpdateEnrollmentStatusRequest updateEnrollmentStatusRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateEnrollmentStatusRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateEnrollmentStatusRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateEnrollmentStatusRequestProtocolMarshaller(protocolFactory).marshall((UpdateEnrollmentStatusRequest)super.beforeMarshalling((AmazonWebServiceRequest)updateEnrollmentStatusRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Compute Optimizer");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UpdateEnrollmentStatus");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdateEnrollmentStatusResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UpdateEnrollmentStatusResult updateEnrollmentStatusResult = (UpdateEnrollmentStatusResult)response.getAwsResponse();
            return updateEnrollmentStatusResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        return this.client.getResponseMetadataForRequest(request);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.invoke(request, responseHandler, executionContext, null, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI cachedEndpoint, URI uriFromEndpointTrait) {
        executionContext.setCredentialsProvider(CredentialUtils.getCredentialsProvider((AmazonWebServiceRequest)request.getOriginalRequest(), (AWSCredentialsProvider)this.awsCredentialsProvider));
        return this.doInvoke(request, responseHandler, executionContext, cachedEndpoint, uriFromEndpointTrait);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> anonymousInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.doInvoke(request, responseHandler, executionContext, null, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> doInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI discoveredEndpoint, URI uriFromEndpointTrait) {
        if (discoveredEndpoint != null) {
            request.setEndpoint(discoveredEndpoint);
            request.getOriginalRequest().getRequestClientOptions().appendUserAgent("endpoint-discovery");
        } else if (uriFromEndpointTrait != null) {
            request.setEndpoint(uriFromEndpointTrait);
        } else {
            request.setEndpoint(this.endpoint);
        }
        request.setTimeOffset(this.timeOffset);
        HttpResponseHandler errorResponseHandler = protocolFactory.createErrorResponseHandler(new JsonErrorResponseMetadata());
        return this.client.execute(request, responseHandler, errorResponseHandler, executionContext);
    }

    @SdkInternalApi
    static SdkJsonProtocolFactory getProtocolFactory() {
        return protocolFactory;
    }

    @Override
    public void shutdown() {
        super.shutdown();
    }
}

