/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.comprehendmedical.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.comprehendmedical.model.Entity;
import java.util.List;

@SdkInternalApi
public class EntityMarshaller {
    private static final MarshallingInfo<Integer> ID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Id").build();
    private static final MarshallingInfo<Integer> BEGINOFFSET_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("BeginOffset").build();
    private static final MarshallingInfo<Integer> ENDOFFSET_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EndOffset").build();
    private static final MarshallingInfo<Float> SCORE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.FLOAT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Score").build();
    private static final MarshallingInfo<String> TEXT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Text").build();
    private static final MarshallingInfo<String> CATEGORY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Category").build();
    private static final MarshallingInfo<String> TYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Type").build();
    private static final MarshallingInfo<List> TRAITS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Traits").build();
    private static final MarshallingInfo<List> ATTRIBUTES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Attributes").build();
    private static final EntityMarshaller instance = new EntityMarshaller();

    public static EntityMarshaller getInstance() {
        return instance;
    }

    public void marshall(Entity entity, ProtocolMarshaller protocolMarshaller) {
        if (entity == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)entity.getId(), ID_BINDING);
            protocolMarshaller.marshall((Object)entity.getBeginOffset(), BEGINOFFSET_BINDING);
            protocolMarshaller.marshall((Object)entity.getEndOffset(), ENDOFFSET_BINDING);
            protocolMarshaller.marshall((Object)entity.getScore(), SCORE_BINDING);
            protocolMarshaller.marshall((Object)entity.getText(), TEXT_BINDING);
            protocolMarshaller.marshall((Object)entity.getCategory(), CATEGORY_BINDING);
            protocolMarshaller.marshall((Object)entity.getType(), TYPE_BINDING);
            protocolMarshaller.marshall(entity.getTraits(), TRAITS_BINDING);
            protocolMarshaller.marshall(entity.getAttributes(), ATTRIBUTES_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

