/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.comprehend.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.comprehend.model.BoundingBox;
import com.amazonaws.services.comprehend.model.Point;
import com.amazonaws.services.comprehend.model.transform.GeometryMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class Geometry
implements Serializable,
Cloneable,
StructuredPojo {
    private BoundingBox boundingBox;
    private List<Point> polygon;

    public void setBoundingBox(BoundingBox boundingBox) {
        this.boundingBox = boundingBox;
    }

    public BoundingBox getBoundingBox() {
        return this.boundingBox;
    }

    public Geometry withBoundingBox(BoundingBox boundingBox) {
        this.setBoundingBox(boundingBox);
        return this;
    }

    public List<Point> getPolygon() {
        return this.polygon;
    }

    public void setPolygon(Collection<Point> polygon) {
        if (polygon == null) {
            this.polygon = null;
            return;
        }
        this.polygon = new ArrayList<Point>(polygon);
    }

    public Geometry withPolygon(Point ... polygon) {
        if (this.polygon == null) {
            this.setPolygon(new ArrayList<Point>(polygon.length));
        }
        for (Point ele : polygon) {
            this.polygon.add(ele);
        }
        return this;
    }

    public Geometry withPolygon(Collection<Point> polygon) {
        this.setPolygon(polygon);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getBoundingBox() != null) {
            sb.append("BoundingBox: ").append(this.getBoundingBox()).append(",");
        }
        if (this.getPolygon() != null) {
            sb.append("Polygon: ").append(this.getPolygon());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Geometry)) {
            return false;
        }
        Geometry other = (Geometry)obj;
        if (other.getBoundingBox() == null ^ this.getBoundingBox() == null) {
            return false;
        }
        if (other.getBoundingBox() != null && !other.getBoundingBox().equals(this.getBoundingBox())) {
            return false;
        }
        if (other.getPolygon() == null ^ this.getPolygon() == null) {
            return false;
        }
        return other.getPolygon() == null || other.getPolygon().equals(this.getPolygon());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getBoundingBox() == null ? 0 : this.getBoundingBox().hashCode());
        hashCode = 31 * hashCode + (this.getPolygon() == null ? 0 : this.getPolygon().hashCode());
        return hashCode;
    }

    public Geometry clone() {
        try {
            return (Geometry)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        GeometryMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

