/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.comprehend.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.comprehend.model.EntityTypesListItem;
import com.amazonaws.services.comprehend.model.transform.EntityRecognitionConfigMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class EntityRecognitionConfig
implements Serializable,
Cloneable,
StructuredPojo {
    private List<EntityTypesListItem> entityTypes;

    public List<EntityTypesListItem> getEntityTypes() {
        return this.entityTypes;
    }

    public void setEntityTypes(Collection<EntityTypesListItem> entityTypes) {
        if (entityTypes == null) {
            this.entityTypes = null;
            return;
        }
        this.entityTypes = new ArrayList<EntityTypesListItem>(entityTypes);
    }

    public EntityRecognitionConfig withEntityTypes(EntityTypesListItem ... entityTypes) {
        if (this.entityTypes == null) {
            this.setEntityTypes(new ArrayList<EntityTypesListItem>(entityTypes.length));
        }
        for (EntityTypesListItem ele : entityTypes) {
            this.entityTypes.add(ele);
        }
        return this;
    }

    public EntityRecognitionConfig withEntityTypes(Collection<EntityTypesListItem> entityTypes) {
        this.setEntityTypes(entityTypes);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getEntityTypes() != null) {
            sb.append("EntityTypes: ").append(this.getEntityTypes());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EntityRecognitionConfig)) {
            return false;
        }
        EntityRecognitionConfig other = (EntityRecognitionConfig)obj;
        if (other.getEntityTypes() == null ^ this.getEntityTypes() == null) {
            return false;
        }
        return other.getEntityTypes() == null || other.getEntityTypes().equals(this.getEntityTypes());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getEntityTypes() == null ? 0 : this.getEntityTypes().hashCode());
        return hashCode;
    }

    public EntityRecognitionConfig clone() {
        try {
            return (EntityRecognitionConfig)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        EntityRecognitionConfigMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

