/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cognitosync.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.cognitosync.model.RegisterDeviceRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.SdkHttpUtils;
import com.amazonaws.util.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class RegisterDeviceRequestMarshaller
implements Marshaller<Request<RegisterDeviceRequest>, RegisterDeviceRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public RegisterDeviceRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<RegisterDeviceRequest> marshall(RegisterDeviceRequest registerDeviceRequest) {
        if (registerDeviceRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)registerDeviceRequest, "AmazonCognitoSync");
        request.setHttpMethod(HttpMethodName.POST);
        String uriResourcePath = "/identitypools/{IdentityPoolId}/identity/{IdentityId}/device";
        uriResourcePath = uriResourcePath.replace("{IdentityPoolId}", registerDeviceRequest.getIdentityPoolId() != null ? SdkHttpUtils.urlEncode((String)StringUtils.fromString((String)registerDeviceRequest.getIdentityPoolId()), (boolean)false) : "");
        uriResourcePath = uriResourcePath.replace("{IdentityId}", registerDeviceRequest.getIdentityId() != null ? SdkHttpUtils.urlEncode((String)StringUtils.fromString((String)registerDeviceRequest.getIdentityId()), (boolean)false) : "");
        request.setResourcePath(uriResourcePath);
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (registerDeviceRequest.getPlatform() != null) {
                jsonGenerator.writeFieldName("Platform").writeValue(registerDeviceRequest.getPlatform());
            }
            if (registerDeviceRequest.getToken() != null) {
                jsonGenerator.writeFieldName("Token").writeValue(registerDeviceRequest.getToken());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            if (!request.getHeaders().containsKey("Content-Type")) {
                request.addHeader("Content-Type", this.protocolFactory.getContentType());
            }
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

