/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cognitosync.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.cognitosync.model.PushSync;
import com.amazonaws.util.json.SdkJsonGenerator;

public class PushSyncJsonMarshaller {
    private static PushSyncJsonMarshaller instance;

    public void marshall(PushSync pushSync, SdkJsonGenerator jsonGenerator) {
        if (pushSync == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonGenerator.writeStartObject();
            SdkInternalList applicationArnsList = (SdkInternalList)pushSync.getApplicationArns();
            if (!applicationArnsList.isEmpty() || !applicationArnsList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("ApplicationArns");
                jsonGenerator.writeStartArray();
                for (String applicationArnsListValue : applicationArnsList) {
                    if (applicationArnsListValue == null) continue;
                    jsonGenerator.writeValue(applicationArnsListValue);
                }
                jsonGenerator.writeEndArray();
            }
            if (pushSync.getRoleArn() != null) {
                jsonGenerator.writeFieldName("RoleArn").writeValue(pushSync.getRoleArn());
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static PushSyncJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new PushSyncJsonMarshaller();
        }
        return instance;
    }
}

