/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cognitoidp.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.cognitoidp.model.ConfirmForgotPasswordRequest;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class ConfirmForgotPasswordRequestMarshaller
implements Marshaller<Request<ConfirmForgotPasswordRequest>, ConfirmForgotPasswordRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public ConfirmForgotPasswordRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<ConfirmForgotPasswordRequest> marshall(ConfirmForgotPasswordRequest confirmForgotPasswordRequest) {
        if (confirmForgotPasswordRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)confirmForgotPasswordRequest, "AWSCognitoIdentityProvider");
        request.addHeader("X-Amz-Target", "AWSCognitoIdentityProviderService.ConfirmForgotPassword");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (confirmForgotPasswordRequest.getClientId() != null) {
                jsonGenerator.writeFieldName("ClientId").writeValue(confirmForgotPasswordRequest.getClientId());
            }
            if (confirmForgotPasswordRequest.getSecretHash() != null) {
                jsonGenerator.writeFieldName("SecretHash").writeValue(confirmForgotPasswordRequest.getSecretHash());
            }
            if (confirmForgotPasswordRequest.getUsername() != null) {
                jsonGenerator.writeFieldName("Username").writeValue(confirmForgotPasswordRequest.getUsername());
            }
            if (confirmForgotPasswordRequest.getConfirmationCode() != null) {
                jsonGenerator.writeFieldName("ConfirmationCode").writeValue(confirmForgotPasswordRequest.getConfirmationCode());
            }
            if (confirmForgotPasswordRequest.getPassword() != null) {
                jsonGenerator.writeFieldName("Password").writeValue(confirmForgotPasswordRequest.getPassword());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

