/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cognitoidp.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.cognitoidp.model.AdminCreateUserRequest;
import com.amazonaws.services.cognitoidp.model.AttributeType;
import com.amazonaws.services.cognitoidp.model.transform.AttributeTypeJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.List;

public class AdminCreateUserRequestMarshaller
implements Marshaller<Request<AdminCreateUserRequest>, AdminCreateUserRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public AdminCreateUserRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<AdminCreateUserRequest> marshall(AdminCreateUserRequest adminCreateUserRequest) {
        if (adminCreateUserRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)adminCreateUserRequest, "AWSCognitoIdentityProvider");
        request.addHeader("X-Amz-Target", "AWSCognitoIdentityProviderService.AdminCreateUser");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            List<String> list;
            List<AttributeType> validationDataList;
            List<AttributeType> userAttributesList;
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (adminCreateUserRequest.getUserPoolId() != null) {
                jsonGenerator.writeFieldName("UserPoolId").writeValue(adminCreateUserRequest.getUserPoolId());
            }
            if (adminCreateUserRequest.getUsername() != null) {
                jsonGenerator.writeFieldName("Username").writeValue(adminCreateUserRequest.getUsername());
            }
            if ((userAttributesList = adminCreateUserRequest.getUserAttributes()) != null) {
                jsonGenerator.writeFieldName("UserAttributes");
                jsonGenerator.writeStartArray();
                for (AttributeType attributeType : userAttributesList) {
                    if (attributeType == null) continue;
                    AttributeTypeJsonMarshaller.getInstance().marshall(attributeType, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            if ((validationDataList = adminCreateUserRequest.getValidationData()) != null) {
                jsonGenerator.writeFieldName("ValidationData");
                jsonGenerator.writeStartArray();
                for (AttributeType attributeType : validationDataList) {
                    if (attributeType == null) continue;
                    AttributeTypeJsonMarshaller.getInstance().marshall(attributeType, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            if (adminCreateUserRequest.getTemporaryPassword() != null) {
                jsonGenerator.writeFieldName("TemporaryPassword").writeValue(adminCreateUserRequest.getTemporaryPassword());
            }
            if (adminCreateUserRequest.getForceAliasCreation() != null) {
                jsonGenerator.writeFieldName("ForceAliasCreation").writeValue(adminCreateUserRequest.getForceAliasCreation().booleanValue());
            }
            if (adminCreateUserRequest.getMessageAction() != null) {
                jsonGenerator.writeFieldName("MessageAction").writeValue(adminCreateUserRequest.getMessageAction());
            }
            if ((list = adminCreateUserRequest.getDesiredDeliveryMediums()) != null) {
                jsonGenerator.writeFieldName("DesiredDeliveryMediums");
                jsonGenerator.writeStartArray();
                for (String desiredDeliveryMediumsListValue : list) {
                    if (desiredDeliveryMediumsListValue == null) continue;
                    jsonGenerator.writeValue(desiredDeliveryMediumsListValue);
                }
                jsonGenerator.writeEndArray();
            }
            jsonGenerator.writeEndObject();
            byte[] byArray = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(byArray));
            request.addHeader("Content-Length", Integer.toString(byArray.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

