/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cognitoidp.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.cognitoidp.model.AdminForgetDeviceRequest;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class AdminForgetDeviceRequestMarshaller
implements Marshaller<Request<AdminForgetDeviceRequest>, AdminForgetDeviceRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public AdminForgetDeviceRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<AdminForgetDeviceRequest> marshall(AdminForgetDeviceRequest adminForgetDeviceRequest) {
        if (adminForgetDeviceRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)adminForgetDeviceRequest, "AWSCognitoIdentityProvider");
        request.addHeader("X-Amz-Target", "AWSCognitoIdentityProviderService.AdminForgetDevice");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (adminForgetDeviceRequest.getUserPoolId() != null) {
                jsonGenerator.writeFieldName("UserPoolId").writeValue(adminForgetDeviceRequest.getUserPoolId());
            }
            if (adminForgetDeviceRequest.getUsername() != null) {
                jsonGenerator.writeFieldName("Username").writeValue(adminForgetDeviceRequest.getUsername());
            }
            if (adminForgetDeviceRequest.getDeviceKey() != null) {
                jsonGenerator.writeFieldName("DeviceKey").writeValue(adminForgetDeviceRequest.getDeviceKey());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

