/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cognitoidp.model;

import com.amazonaws.services.cognitoidp.model.UserType;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ListUsersResult
implements Serializable,
Cloneable {
    private List<UserType> users;
    private String paginationToken;

    public List<UserType> getUsers() {
        return this.users;
    }

    public void setUsers(Collection<UserType> users) {
        if (users == null) {
            this.users = null;
            return;
        }
        this.users = new ArrayList<UserType>(users);
    }

    public ListUsersResult withUsers(UserType ... users) {
        if (this.users == null) {
            this.setUsers(new ArrayList<UserType>(users.length));
        }
        for (UserType ele : users) {
            this.users.add(ele);
        }
        return this;
    }

    public ListUsersResult withUsers(Collection<UserType> users) {
        this.setUsers(users);
        return this;
    }

    public void setPaginationToken(String paginationToken) {
        this.paginationToken = paginationToken;
    }

    public String getPaginationToken() {
        return this.paginationToken;
    }

    public ListUsersResult withPaginationToken(String paginationToken) {
        this.setPaginationToken(paginationToken);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getUsers() != null) {
            sb.append("Users: " + this.getUsers() + ",");
        }
        if (this.getPaginationToken() != null) {
            sb.append("PaginationToken: " + this.getPaginationToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListUsersResult)) {
            return false;
        }
        ListUsersResult other = (ListUsersResult)obj;
        if (other.getUsers() == null ^ this.getUsers() == null) {
            return false;
        }
        if (other.getUsers() != null && !other.getUsers().equals(this.getUsers())) {
            return false;
        }
        if (other.getPaginationToken() == null ^ this.getPaginationToken() == null) {
            return false;
        }
        return other.getPaginationToken() == null || other.getPaginationToken().equals(this.getPaginationToken());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getUsers() == null ? 0 : this.getUsers().hashCode());
        hashCode = 31 * hashCode + (this.getPaginationToken() == null ? 0 : this.getPaginationToken().hashCode());
        return hashCode;
    }

    public ListUsersResult clone() {
        try {
            return (ListUsersResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

