/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cognitoidp.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.cognitoidp.model.CreateUserPoolRequest;
import com.amazonaws.services.cognitoidp.model.transform.LambdaConfigTypeJsonMarshaller;
import com.amazonaws.services.cognitoidp.model.transform.UserPoolPolicyTypeJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.json.SdkJsonProtocolFactory;
import com.amazonaws.util.json.StructuredJsonGenerator;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.List;

public class CreateUserPoolRequestMarshaller
implements Marshaller<Request<CreateUserPoolRequest>, CreateUserPoolRequest> {
    public Request<CreateUserPoolRequest> marshall(CreateUserPoolRequest createUserPoolRequest) {
        if (createUserPoolRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createUserPoolRequest, "AWSCognitoIdentityProvider");
        request.addHeader("X-Amz-Target", "AWSCognitoIdentityProviderService.CreateUserPool");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            List<String> aliasAttributesList;
            List<String> autoVerifiedAttributesList;
            StructuredJsonGenerator jsonGenerator = SdkJsonProtocolFactory.createWriter((boolean)false, (String)"1.1");
            jsonGenerator.writeStartObject();
            if (createUserPoolRequest.getPoolName() != null) {
                jsonGenerator.writeFieldName("PoolName").writeValue(createUserPoolRequest.getPoolName());
            }
            if (createUserPoolRequest.getPolicies() != null) {
                jsonGenerator.writeFieldName("Policies");
                UserPoolPolicyTypeJsonMarshaller.getInstance().marshall(createUserPoolRequest.getPolicies(), jsonGenerator);
            }
            if (createUserPoolRequest.getLambdaConfig() != null) {
                jsonGenerator.writeFieldName("LambdaConfig");
                LambdaConfigTypeJsonMarshaller.getInstance().marshall(createUserPoolRequest.getLambdaConfig(), jsonGenerator);
            }
            if ((autoVerifiedAttributesList = createUserPoolRequest.getAutoVerifiedAttributes()) != null) {
                jsonGenerator.writeFieldName("AutoVerifiedAttributes");
                jsonGenerator.writeStartArray();
                for (String string : autoVerifiedAttributesList) {
                    if (string == null) continue;
                    jsonGenerator.writeValue(string);
                }
                jsonGenerator.writeEndArray();
            }
            if ((aliasAttributesList = createUserPoolRequest.getAliasAttributes()) != null) {
                jsonGenerator.writeFieldName("AliasAttributes");
                jsonGenerator.writeStartArray();
                for (String aliasAttributesListValue : aliasAttributesList) {
                    if (aliasAttributesListValue == null) continue;
                    jsonGenerator.writeValue(aliasAttributesListValue);
                }
                jsonGenerator.writeEndArray();
            }
            if (createUserPoolRequest.getSmsVerificationMessage() != null) {
                jsonGenerator.writeFieldName("SmsVerificationMessage").writeValue(createUserPoolRequest.getSmsVerificationMessage());
            }
            if (createUserPoolRequest.getEmailVerificationMessage() != null) {
                jsonGenerator.writeFieldName("EmailVerificationMessage").writeValue(createUserPoolRequest.getEmailVerificationMessage());
            }
            if (createUserPoolRequest.getEmailVerificationSubject() != null) {
                jsonGenerator.writeFieldName("EmailVerificationSubject").writeValue(createUserPoolRequest.getEmailVerificationSubject());
            }
            if (createUserPoolRequest.getSmsAuthenticationMessage() != null) {
                jsonGenerator.writeFieldName("SmsAuthenticationMessage").writeValue(createUserPoolRequest.getSmsAuthenticationMessage());
            }
            if (createUserPoolRequest.getMfaConfiguration() != null) {
                jsonGenerator.writeFieldName("MfaConfiguration").writeValue(createUserPoolRequest.getMfaConfiguration());
            }
            jsonGenerator.writeEndObject();
            byte[] byArray = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(byArray));
            request.addHeader("Content-Length", Integer.toString(byArray.length));
            request.addHeader("Content-Type", jsonGenerator.getContentType());
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

