/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cognitoidentity.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.cognitoidentity.model.IdentityDescription;
import java.util.List;

public class IdentityDescriptionJsonMarshaller {
    private static IdentityDescriptionJsonMarshaller instance;

    public void marshall(IdentityDescription identityDescription, StructuredJsonGenerator jsonGenerator) {
        if (identityDescription == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            List<String> loginsList;
            jsonGenerator.writeStartObject();
            if (identityDescription.getIdentityId() != null) {
                jsonGenerator.writeFieldName("IdentityId").writeValue(identityDescription.getIdentityId());
            }
            if ((loginsList = identityDescription.getLogins()) != null) {
                jsonGenerator.writeFieldName("Logins");
                jsonGenerator.writeStartArray();
                for (String loginsListValue : loginsList) {
                    if (loginsListValue == null) continue;
                    jsonGenerator.writeValue(loginsListValue);
                }
                jsonGenerator.writeEndArray();
            }
            if (identityDescription.getCreationDate() != null) {
                jsonGenerator.writeFieldName("CreationDate").writeValue(identityDescription.getCreationDate());
            }
            if (identityDescription.getLastModifiedDate() != null) {
                jsonGenerator.writeFieldName("LastModifiedDate").writeValue(identityDescription.getLastModifiedDate());
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static IdentityDescriptionJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new IdentityDescriptionJsonMarshaller();
        }
        return instance;
    }
}

