/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.codestar.model.transform;

import com.amazonaws.services.codestar.model.CodeSource;
import com.amazonaws.services.codestar.model.transform.S3LocationJsonUnmarshaller;
import com.amazonaws.transform.JsonUnmarshallerContext;
import com.amazonaws.transform.UnknownMemberJsonUnmarshaller;
import com.amazonaws.transform.Unmarshaller;
import com.fasterxml.jackson.core.JsonToken;

public class CodeSourceJsonUnmarshaller
implements Unmarshaller<CodeSource, JsonUnmarshallerContext> {
    private static CodeSourceJsonUnmarshaller instance;

    public CodeSource unmarshall(JsonUnmarshallerContext context) throws Exception {
        CodeSource codeSource = new CodeSource();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            boolean knownMember = false;
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("s3", targetDepth)) {
                    knownMember = true;
                    context.nextToken();
                    codeSource.setS3(S3LocationJsonUnmarshaller.getInstance().unmarshall(context));
                }
                if (token == JsonToken.FIELD_NAME && !knownMember) {
                    context.nextToken();
                    UnknownMemberJsonUnmarshaller.getInstance().unmarshall(context);
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return codeSource;
    }

    public static CodeSourceJsonUnmarshaller getInstance() {
        if (instance == null) {
            instance = new CodeSourceJsonUnmarshaller();
        }
        return instance;
    }
}

