/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.codepipeline.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.codepipeline.model.GitBranchFilterCriteria;
import com.amazonaws.services.codepipeline.model.GitFilePathFilterCriteria;
import com.amazonaws.services.codepipeline.model.GitPullRequestEventType;
import com.amazonaws.services.codepipeline.model.transform.GitPullRequestFilterMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class GitPullRequestFilter
implements Serializable,
Cloneable,
StructuredPojo {
    private List<String> events;
    private GitBranchFilterCriteria branches;
    private GitFilePathFilterCriteria filePaths;

    public List<String> getEvents() {
        return this.events;
    }

    public void setEvents(Collection<String> events) {
        if (events == null) {
            this.events = null;
            return;
        }
        this.events = new ArrayList<String>(events);
    }

    public GitPullRequestFilter withEvents(String ... events) {
        if (this.events == null) {
            this.setEvents(new ArrayList<String>(events.length));
        }
        for (String ele : events) {
            this.events.add(ele);
        }
        return this;
    }

    public GitPullRequestFilter withEvents(Collection<String> events) {
        this.setEvents(events);
        return this;
    }

    public GitPullRequestFilter withEvents(GitPullRequestEventType ... events) {
        ArrayList<String> eventsCopy = new ArrayList<String>(events.length);
        for (GitPullRequestEventType value : events) {
            eventsCopy.add(value.toString());
        }
        if (this.getEvents() == null) {
            this.setEvents(eventsCopy);
        } else {
            this.getEvents().addAll(eventsCopy);
        }
        return this;
    }

    public void setBranches(GitBranchFilterCriteria branches) {
        this.branches = branches;
    }

    public GitBranchFilterCriteria getBranches() {
        return this.branches;
    }

    public GitPullRequestFilter withBranches(GitBranchFilterCriteria branches) {
        this.setBranches(branches);
        return this;
    }

    public void setFilePaths(GitFilePathFilterCriteria filePaths) {
        this.filePaths = filePaths;
    }

    public GitFilePathFilterCriteria getFilePaths() {
        return this.filePaths;
    }

    public GitPullRequestFilter withFilePaths(GitFilePathFilterCriteria filePaths) {
        this.setFilePaths(filePaths);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getEvents() != null) {
            sb.append("Events: ").append(this.getEvents()).append(",");
        }
        if (this.getBranches() != null) {
            sb.append("Branches: ").append(this.getBranches()).append(",");
        }
        if (this.getFilePaths() != null) {
            sb.append("FilePaths: ").append(this.getFilePaths());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GitPullRequestFilter)) {
            return false;
        }
        GitPullRequestFilter other = (GitPullRequestFilter)obj;
        if (other.getEvents() == null ^ this.getEvents() == null) {
            return false;
        }
        if (other.getEvents() != null && !other.getEvents().equals(this.getEvents())) {
            return false;
        }
        if (other.getBranches() == null ^ this.getBranches() == null) {
            return false;
        }
        if (other.getBranches() != null && !other.getBranches().equals(this.getBranches())) {
            return false;
        }
        if (other.getFilePaths() == null ^ this.getFilePaths() == null) {
            return false;
        }
        return other.getFilePaths() == null || other.getFilePaths().equals(this.getFilePaths());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getEvents() == null ? 0 : this.getEvents().hashCode());
        hashCode = 31 * hashCode + (this.getBranches() == null ? 0 : this.getBranches().hashCode());
        hashCode = 31 * hashCode + (this.getFilePaths() == null ? 0 : this.getFilePaths().hashCode());
        return hashCode;
    }

    public GitPullRequestFilter clone() {
        try {
            return (GitPullRequestFilter)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        GitPullRequestFilterMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

