/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.codepipeline.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.codepipeline.model.Tag;
import com.amazonaws.services.codepipeline.model.WebhookDefinition;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class PutWebhookRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private WebhookDefinition webhook;
    private List<Tag> tags;

    public void setWebhook(WebhookDefinition webhook) {
        this.webhook = webhook;
    }

    public WebhookDefinition getWebhook() {
        return this.webhook;
    }

    public PutWebhookRequest withWebhook(WebhookDefinition webhook) {
        this.setWebhook(webhook);
        return this;
    }

    public List<Tag> getTags() {
        return this.tags;
    }

    public void setTags(Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }
        this.tags = new ArrayList<Tag>(tags);
    }

    public PutWebhookRequest withTags(Tag ... tags) {
        if (this.tags == null) {
            this.setTags(new ArrayList<Tag>(tags.length));
        }
        for (Tag ele : tags) {
            this.tags.add(ele);
        }
        return this;
    }

    public PutWebhookRequest withTags(Collection<Tag> tags) {
        this.setTags(tags);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getWebhook() != null) {
            sb.append("Webhook: ").append(this.getWebhook()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutWebhookRequest)) {
            return false;
        }
        PutWebhookRequest other = (PutWebhookRequest)obj;
        if (other.getWebhook() == null ^ this.getWebhook() == null) {
            return false;
        }
        if (other.getWebhook() != null && !other.getWebhook().equals(this.getWebhook())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        return other.getTags() == null || other.getTags().equals(this.getTags());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getWebhook() == null ? 0 : this.getWebhook().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        return hashCode;
    }

    public PutWebhookRequest clone() {
        return (PutWebhookRequest)super.clone();
    }
}

