/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.codepipeline.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.codepipeline.model.transform.ActionConfigurationMarshaller;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class ActionConfiguration
implements Serializable,
Cloneable,
StructuredPojo {
    private Map<String, String> configuration;

    public Map<String, String> getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(Map<String, String> configuration) {
        this.configuration = configuration;
    }

    public ActionConfiguration withConfiguration(Map<String, String> configuration) {
        this.setConfiguration(configuration);
        return this;
    }

    public ActionConfiguration addConfigurationEntry(String key, String value) {
        if (null == this.configuration) {
            this.configuration = new HashMap<String, String>();
        }
        if (this.configuration.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.configuration.put(key, value);
        return this;
    }

    public ActionConfiguration clearConfigurationEntries() {
        this.configuration = null;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getConfiguration() != null) {
            sb.append("Configuration: ").append(this.getConfiguration());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ActionConfiguration)) {
            return false;
        }
        ActionConfiguration other = (ActionConfiguration)obj;
        if (other.getConfiguration() == null ^ this.getConfiguration() == null) {
            return false;
        }
        return other.getConfiguration() == null || other.getConfiguration().equals(this.getConfiguration());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getConfiguration() == null ? 0 : this.getConfiguration().hashCode());
        return hashCode;
    }

    public ActionConfiguration clone() {
        try {
            return (ActionConfiguration)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ActionConfigurationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

