/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.codegurureviewer;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.codegurureviewer.AmazonCodeGuruReviewerAsync;
import com.amazonaws.services.codegurureviewer.AmazonCodeGuruReviewerAsyncClientBuilder;
import com.amazonaws.services.codegurureviewer.AmazonCodeGuruReviewerClient;
import com.amazonaws.services.codegurureviewer.model.AssociateRepositoryRequest;
import com.amazonaws.services.codegurureviewer.model.AssociateRepositoryResult;
import com.amazonaws.services.codegurureviewer.model.CreateCodeReviewRequest;
import com.amazonaws.services.codegurureviewer.model.CreateCodeReviewResult;
import com.amazonaws.services.codegurureviewer.model.DescribeCodeReviewRequest;
import com.amazonaws.services.codegurureviewer.model.DescribeCodeReviewResult;
import com.amazonaws.services.codegurureviewer.model.DescribeRecommendationFeedbackRequest;
import com.amazonaws.services.codegurureviewer.model.DescribeRecommendationFeedbackResult;
import com.amazonaws.services.codegurureviewer.model.DescribeRepositoryAssociationRequest;
import com.amazonaws.services.codegurureviewer.model.DescribeRepositoryAssociationResult;
import com.amazonaws.services.codegurureviewer.model.DisassociateRepositoryRequest;
import com.amazonaws.services.codegurureviewer.model.DisassociateRepositoryResult;
import com.amazonaws.services.codegurureviewer.model.ListCodeReviewsRequest;
import com.amazonaws.services.codegurureviewer.model.ListCodeReviewsResult;
import com.amazonaws.services.codegurureviewer.model.ListRecommendationFeedbackRequest;
import com.amazonaws.services.codegurureviewer.model.ListRecommendationFeedbackResult;
import com.amazonaws.services.codegurureviewer.model.ListRecommendationsRequest;
import com.amazonaws.services.codegurureviewer.model.ListRecommendationsResult;
import com.amazonaws.services.codegurureviewer.model.ListRepositoryAssociationsRequest;
import com.amazonaws.services.codegurureviewer.model.ListRepositoryAssociationsResult;
import com.amazonaws.services.codegurureviewer.model.ListTagsForResourceRequest;
import com.amazonaws.services.codegurureviewer.model.ListTagsForResourceResult;
import com.amazonaws.services.codegurureviewer.model.PutRecommendationFeedbackRequest;
import com.amazonaws.services.codegurureviewer.model.PutRecommendationFeedbackResult;
import com.amazonaws.services.codegurureviewer.model.TagResourceRequest;
import com.amazonaws.services.codegurureviewer.model.TagResourceResult;
import com.amazonaws.services.codegurureviewer.model.UntagResourceRequest;
import com.amazonaws.services.codegurureviewer.model.UntagResourceResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

@ThreadSafe
public class AmazonCodeGuruReviewerAsyncClient
extends AmazonCodeGuruReviewerClient
implements AmazonCodeGuruReviewerAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    public static AmazonCodeGuruReviewerAsyncClientBuilder asyncBuilder() {
        return AmazonCodeGuruReviewerAsyncClientBuilder.standard();
    }

    AmazonCodeGuruReviewerAsyncClient(AwsAsyncClientParams asyncClientParams) {
        this(asyncClientParams, false);
    }

    AmazonCodeGuruReviewerAsyncClient(AwsAsyncClientParams asyncClientParams, boolean endpointDiscoveryEnabled) {
        super((AwsSyncClientParams)asyncClientParams, endpointDiscoveryEnabled);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<AssociateRepositoryResult> associateRepositoryAsync(AssociateRepositoryRequest request) {
        return this.associateRepositoryAsync(request, null);
    }

    @Override
    public Future<AssociateRepositoryResult> associateRepositoryAsync(AssociateRepositoryRequest request, final AsyncHandler<AssociateRepositoryRequest, AssociateRepositoryResult> asyncHandler) {
        final AssociateRepositoryRequest finalRequest = (AssociateRepositoryRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<AssociateRepositoryResult>(){

            @Override
            public AssociateRepositoryResult call() throws Exception {
                AssociateRepositoryResult result = null;
                try {
                    result = AmazonCodeGuruReviewerAsyncClient.this.executeAssociateRepository(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateCodeReviewResult> createCodeReviewAsync(CreateCodeReviewRequest request) {
        return this.createCodeReviewAsync(request, null);
    }

    @Override
    public Future<CreateCodeReviewResult> createCodeReviewAsync(CreateCodeReviewRequest request, final AsyncHandler<CreateCodeReviewRequest, CreateCodeReviewResult> asyncHandler) {
        final CreateCodeReviewRequest finalRequest = (CreateCodeReviewRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateCodeReviewResult>(){

            @Override
            public CreateCodeReviewResult call() throws Exception {
                CreateCodeReviewResult result = null;
                try {
                    result = AmazonCodeGuruReviewerAsyncClient.this.executeCreateCodeReview(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeCodeReviewResult> describeCodeReviewAsync(DescribeCodeReviewRequest request) {
        return this.describeCodeReviewAsync(request, null);
    }

    @Override
    public Future<DescribeCodeReviewResult> describeCodeReviewAsync(DescribeCodeReviewRequest request, final AsyncHandler<DescribeCodeReviewRequest, DescribeCodeReviewResult> asyncHandler) {
        final DescribeCodeReviewRequest finalRequest = (DescribeCodeReviewRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeCodeReviewResult>(){

            @Override
            public DescribeCodeReviewResult call() throws Exception {
                DescribeCodeReviewResult result = null;
                try {
                    result = AmazonCodeGuruReviewerAsyncClient.this.executeDescribeCodeReview(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeRecommendationFeedbackResult> describeRecommendationFeedbackAsync(DescribeRecommendationFeedbackRequest request) {
        return this.describeRecommendationFeedbackAsync(request, null);
    }

    @Override
    public Future<DescribeRecommendationFeedbackResult> describeRecommendationFeedbackAsync(DescribeRecommendationFeedbackRequest request, final AsyncHandler<DescribeRecommendationFeedbackRequest, DescribeRecommendationFeedbackResult> asyncHandler) {
        final DescribeRecommendationFeedbackRequest finalRequest = (DescribeRecommendationFeedbackRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeRecommendationFeedbackResult>(){

            @Override
            public DescribeRecommendationFeedbackResult call() throws Exception {
                DescribeRecommendationFeedbackResult result = null;
                try {
                    result = AmazonCodeGuruReviewerAsyncClient.this.executeDescribeRecommendationFeedback(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeRepositoryAssociationResult> describeRepositoryAssociationAsync(DescribeRepositoryAssociationRequest request) {
        return this.describeRepositoryAssociationAsync(request, null);
    }

    @Override
    public Future<DescribeRepositoryAssociationResult> describeRepositoryAssociationAsync(DescribeRepositoryAssociationRequest request, final AsyncHandler<DescribeRepositoryAssociationRequest, DescribeRepositoryAssociationResult> asyncHandler) {
        final DescribeRepositoryAssociationRequest finalRequest = (DescribeRepositoryAssociationRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeRepositoryAssociationResult>(){

            @Override
            public DescribeRepositoryAssociationResult call() throws Exception {
                DescribeRepositoryAssociationResult result = null;
                try {
                    result = AmazonCodeGuruReviewerAsyncClient.this.executeDescribeRepositoryAssociation(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DisassociateRepositoryResult> disassociateRepositoryAsync(DisassociateRepositoryRequest request) {
        return this.disassociateRepositoryAsync(request, null);
    }

    @Override
    public Future<DisassociateRepositoryResult> disassociateRepositoryAsync(DisassociateRepositoryRequest request, final AsyncHandler<DisassociateRepositoryRequest, DisassociateRepositoryResult> asyncHandler) {
        final DisassociateRepositoryRequest finalRequest = (DisassociateRepositoryRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DisassociateRepositoryResult>(){

            @Override
            public DisassociateRepositoryResult call() throws Exception {
                DisassociateRepositoryResult result = null;
                try {
                    result = AmazonCodeGuruReviewerAsyncClient.this.executeDisassociateRepository(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListCodeReviewsResult> listCodeReviewsAsync(ListCodeReviewsRequest request) {
        return this.listCodeReviewsAsync(request, null);
    }

    @Override
    public Future<ListCodeReviewsResult> listCodeReviewsAsync(ListCodeReviewsRequest request, final AsyncHandler<ListCodeReviewsRequest, ListCodeReviewsResult> asyncHandler) {
        final ListCodeReviewsRequest finalRequest = (ListCodeReviewsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListCodeReviewsResult>(){

            @Override
            public ListCodeReviewsResult call() throws Exception {
                ListCodeReviewsResult result = null;
                try {
                    result = AmazonCodeGuruReviewerAsyncClient.this.executeListCodeReviews(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListRecommendationFeedbackResult> listRecommendationFeedbackAsync(ListRecommendationFeedbackRequest request) {
        return this.listRecommendationFeedbackAsync(request, null);
    }

    @Override
    public Future<ListRecommendationFeedbackResult> listRecommendationFeedbackAsync(ListRecommendationFeedbackRequest request, final AsyncHandler<ListRecommendationFeedbackRequest, ListRecommendationFeedbackResult> asyncHandler) {
        final ListRecommendationFeedbackRequest finalRequest = (ListRecommendationFeedbackRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListRecommendationFeedbackResult>(){

            @Override
            public ListRecommendationFeedbackResult call() throws Exception {
                ListRecommendationFeedbackResult result = null;
                try {
                    result = AmazonCodeGuruReviewerAsyncClient.this.executeListRecommendationFeedback(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListRecommendationsResult> listRecommendationsAsync(ListRecommendationsRequest request) {
        return this.listRecommendationsAsync(request, null);
    }

    @Override
    public Future<ListRecommendationsResult> listRecommendationsAsync(ListRecommendationsRequest request, final AsyncHandler<ListRecommendationsRequest, ListRecommendationsResult> asyncHandler) {
        final ListRecommendationsRequest finalRequest = (ListRecommendationsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListRecommendationsResult>(){

            @Override
            public ListRecommendationsResult call() throws Exception {
                ListRecommendationsResult result = null;
                try {
                    result = AmazonCodeGuruReviewerAsyncClient.this.executeListRecommendations(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListRepositoryAssociationsResult> listRepositoryAssociationsAsync(ListRepositoryAssociationsRequest request) {
        return this.listRepositoryAssociationsAsync(request, null);
    }

    @Override
    public Future<ListRepositoryAssociationsResult> listRepositoryAssociationsAsync(ListRepositoryAssociationsRequest request, final AsyncHandler<ListRepositoryAssociationsRequest, ListRepositoryAssociationsResult> asyncHandler) {
        final ListRepositoryAssociationsRequest finalRequest = (ListRepositoryAssociationsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListRepositoryAssociationsResult>(){

            @Override
            public ListRepositoryAssociationsResult call() throws Exception {
                ListRepositoryAssociationsResult result = null;
                try {
                    result = AmazonCodeGuruReviewerAsyncClient.this.executeListRepositoryAssociations(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListTagsForResourceResult> listTagsForResourceAsync(ListTagsForResourceRequest request) {
        return this.listTagsForResourceAsync(request, null);
    }

    @Override
    public Future<ListTagsForResourceResult> listTagsForResourceAsync(ListTagsForResourceRequest request, final AsyncHandler<ListTagsForResourceRequest, ListTagsForResourceResult> asyncHandler) {
        final ListTagsForResourceRequest finalRequest = (ListTagsForResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListTagsForResourceResult>(){

            @Override
            public ListTagsForResourceResult call() throws Exception {
                ListTagsForResourceResult result = null;
                try {
                    result = AmazonCodeGuruReviewerAsyncClient.this.executeListTagsForResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<PutRecommendationFeedbackResult> putRecommendationFeedbackAsync(PutRecommendationFeedbackRequest request) {
        return this.putRecommendationFeedbackAsync(request, null);
    }

    @Override
    public Future<PutRecommendationFeedbackResult> putRecommendationFeedbackAsync(PutRecommendationFeedbackRequest request, final AsyncHandler<PutRecommendationFeedbackRequest, PutRecommendationFeedbackResult> asyncHandler) {
        final PutRecommendationFeedbackRequest finalRequest = (PutRecommendationFeedbackRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<PutRecommendationFeedbackResult>(){

            @Override
            public PutRecommendationFeedbackResult call() throws Exception {
                PutRecommendationFeedbackResult result = null;
                try {
                    result = AmazonCodeGuruReviewerAsyncClient.this.executePutRecommendationFeedback(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<TagResourceResult> tagResourceAsync(TagResourceRequest request) {
        return this.tagResourceAsync(request, null);
    }

    @Override
    public Future<TagResourceResult> tagResourceAsync(TagResourceRequest request, final AsyncHandler<TagResourceRequest, TagResourceResult> asyncHandler) {
        final TagResourceRequest finalRequest = (TagResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<TagResourceResult>(){

            @Override
            public TagResourceResult call() throws Exception {
                TagResourceResult result = null;
                try {
                    result = AmazonCodeGuruReviewerAsyncClient.this.executeTagResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UntagResourceResult> untagResourceAsync(UntagResourceRequest request) {
        return this.untagResourceAsync(request, null);
    }

    @Override
    public Future<UntagResourceResult> untagResourceAsync(UntagResourceRequest request, final AsyncHandler<UntagResourceRequest, UntagResourceResult> asyncHandler) {
        final UntagResourceRequest finalRequest = (UntagResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UntagResourceResult>(){

            @Override
            public UntagResourceResult call() throws Exception {
                UntagResourceResult result = null;
                try {
                    result = AmazonCodeGuruReviewerAsyncClient.this.executeUntagResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

