/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.codegurureviewer.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.codegurureviewer.model.S3Repository;

@SdkInternalApi
public class S3RepositoryMarshaller {
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Name").build();
    private static final MarshallingInfo<String> BUCKETNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("BucketName").build();
    private static final S3RepositoryMarshaller instance = new S3RepositoryMarshaller();

    public static S3RepositoryMarshaller getInstance() {
        return instance;
    }

    public void marshall(S3Repository s3Repository, ProtocolMarshaller protocolMarshaller) {
        if (s3Repository == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)s3Repository.getName(), NAME_BINDING);
            protocolMarshaller.marshall((Object)s3Repository.getBucketName(), BUCKETNAME_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

