/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.codeguruprofiler.model.transform;

import com.amazonaws.services.codeguruprofiler.model.Metric;
import com.amazonaws.transform.JsonUnmarshallerContext;
import com.amazonaws.transform.ListUnmarshaller;
import com.amazonaws.transform.UnknownMemberJsonUnmarshaller;
import com.amazonaws.transform.Unmarshaller;
import com.fasterxml.jackson.core.JsonToken;

public class MetricJsonUnmarshaller
implements Unmarshaller<Metric, JsonUnmarshallerContext> {
    private static MetricJsonUnmarshaller instance;

    public Metric unmarshall(JsonUnmarshallerContext context) throws Exception {
        Metric metric = new Metric();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            boolean knownMember = false;
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("frameName", targetDepth)) {
                    knownMember = true;
                    context.nextToken();
                    metric.setFrameName((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("threadStates", targetDepth)) {
                    knownMember = true;
                    context.nextToken();
                    metric.setThreadStates(new ListUnmarshaller(context.getUnmarshaller(String.class)).unmarshall(context));
                }
                if (context.testExpression("type", targetDepth)) {
                    knownMember = true;
                    context.nextToken();
                    metric.setType((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (token == JsonToken.FIELD_NAME && !knownMember) {
                    context.nextToken();
                    UnknownMemberJsonUnmarshaller.getInstance().unmarshall(context);
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return metric;
    }

    public static MetricJsonUnmarshaller getInstance() {
        if (instance == null) {
            instance = new MetricJsonUnmarshaller();
        }
        return instance;
    }
}

